package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDirectoriesAndFiles invokes the nas.ListDirectoriesAndFiles API synchronously
func (client *Client) ListDirectoriesAndFiles(request *ListDirectoriesAndFilesRequest) (response *ListDirectoriesAndFilesResponse, err error) {
	response = CreateListDirectoriesAndFilesResponse()
	err = client.DoAction(request, response)
	return
}

// ListDirectoriesAndFilesWithChan invokes the nas.ListDirectoriesAndFiles API asynchronously
func (client *Client) ListDirectoriesAndFilesWithChan(request *ListDirectoriesAndFilesRequest) (<-chan *ListDirectoriesAndFilesResponse, <-chan error) {
	responseChan := make(chan *ListDirectoriesAndFilesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDirectoriesAndFiles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDirectoriesAndFilesWithCallback invokes the nas.ListDirectoriesAndFiles API asynchronously
func (client *Client) ListDirectoriesAndFilesWithCallback(request *ListDirectoriesAndFilesRequest, callback func(response *ListDirectoriesAndFilesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDirectoriesAndFilesResponse
		var err error
		defer close(result)
		response, err = client.ListDirectoriesAndFiles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDirectoriesAndFilesRequest is the request struct for api ListDirectoriesAndFiles
type ListDirectoriesAndFilesRequest struct {
	*requests.RpcRequest
	DirectoryOnly requests.Boolean `position:"Query" name:"DirectoryOnly"`
	StorageType   string           `position:"Query" name:"StorageType"`
	Path          string           `position:"Query" name:"Path"`
	NextToken     string           `position:"Query" name:"NextToken"`
	FileSystemId  string           `position:"Query" name:"FileSystemId"`
	MaxResults    requests.Integer `position:"Query" name:"MaxResults"`
}

// ListDirectoriesAndFilesResponse is the response struct for api ListDirectoriesAndFiles
type ListDirectoriesAndFilesResponse struct {
	*responses.BaseResponse
	NextToken string  `json:"NextToken" xml:"NextToken"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Entries   []Entry `json:"Entries" xml:"Entries"`
}

// CreateListDirectoriesAndFilesRequest creates a request to invoke ListDirectoriesAndFiles API
func CreateListDirectoriesAndFilesRequest() (request *ListDirectoriesAndFilesRequest) {
	request = &ListDirectoriesAndFilesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "ListDirectoriesAndFiles", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDirectoriesAndFilesResponse creates a response to parse from ListDirectoriesAndFiles response
func CreateListDirectoriesAndFilesResponse() (response *ListDirectoriesAndFilesResponse) {
	response = &ListDirectoriesAndFilesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
