package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRecycleBinRestoreJob invokes the nas.CreateRecycleBinRestoreJob API synchronously
func (client *Client) CreateRecycleBinRestoreJob(request *CreateRecycleBinRestoreJobRequest) (response *CreateRecycleBinRestoreJobResponse, err error) {
	response = CreateCreateRecycleBinRestoreJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRecycleBinRestoreJobWithChan invokes the nas.CreateRecycleBinRestoreJob API asynchronously
func (client *Client) CreateRecycleBinRestoreJobWithChan(request *CreateRecycleBinRestoreJobRequest) (<-chan *CreateRecycleBinRestoreJobResponse, <-chan error) {
	responseChan := make(chan *CreateRecycleBinRestoreJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRecycleBinRestoreJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRecycleBinRestoreJobWithCallback invokes the nas.CreateRecycleBinRestoreJob API asynchronously
func (client *Client) CreateRecycleBinRestoreJobWithCallback(request *CreateRecycleBinRestoreJobRequest, callback func(response *CreateRecycleBinRestoreJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRecycleBinRestoreJobResponse
		var err error
		defer close(result)
		response, err = client.CreateRecycleBinRestoreJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRecycleBinRestoreJobRequest is the request struct for api CreateRecycleBinRestoreJob
type CreateRecycleBinRestoreJobRequest struct {
	*requests.RpcRequest
	ClientToken  string `position:"Query" name:"ClientToken"`
	FileSystemId string `position:"Query" name:"FileSystemId"`
	FileId       string `position:"Query" name:"FileId"`
	TargetFileId string `position:"Query" name:"TargetFileId"`
}

// CreateRecycleBinRestoreJobResponse is the response struct for api CreateRecycleBinRestoreJob
type CreateRecycleBinRestoreJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateCreateRecycleBinRestoreJobRequest creates a request to invoke CreateRecycleBinRestoreJob API
func CreateCreateRecycleBinRestoreJobRequest() (request *CreateRecycleBinRestoreJobRequest) {
	request = &CreateRecycleBinRestoreJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "CreateRecycleBinRestoreJob", "nas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateCreateRecycleBinRestoreJobResponse creates a response to parse from CreateRecycleBinRestoreJob response
func CreateCreateRecycleBinRestoreJobResponse() (response *CreateRecycleBinRestoreJobResponse) {
	response = &CreateRecycleBinRestoreJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
