package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryClusterInfo invokes the mse.QueryClusterInfo API synchronously
func (client *Client) QueryClusterInfo(request *QueryClusterInfoRequest) (response *QueryClusterInfoResponse, err error) {
	response = CreateQueryClusterInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryClusterInfoWithChan invokes the mse.QueryClusterInfo API asynchronously
func (client *Client) QueryClusterInfoWithChan(request *QueryClusterInfoRequest) (<-chan *QueryClusterInfoResponse, <-chan error) {
	responseChan := make(chan *QueryClusterInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryClusterInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryClusterInfoWithCallback invokes the mse.QueryClusterInfo API asynchronously
func (client *Client) QueryClusterInfoWithCallback(request *QueryClusterInfoRequest, callback func(response *QueryClusterInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryClusterInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryClusterInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryClusterInfoRequest is the request struct for api QueryClusterInfo
type QueryClusterInfoRequest struct {
	*requests.RpcRequest
	AclSwitch      requests.Boolean `position:"Query" name:"AclSwitch"`
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	OrderId        string           `position:"Query" name:"OrderId"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	RequestPars    string           `position:"Query" name:"RequestPars"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// QueryClusterInfoResponse is the response struct for api QueryClusterInfo
type QueryClusterInfoResponse struct {
	*responses.BaseResponse
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	ErrorCode string                 `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool                   `json:"Success" xml:"Success"`
	Data      DataInQueryClusterInfo `json:"Data" xml:"Data"`
}

// CreateQueryClusterInfoRequest creates a request to invoke QueryClusterInfo API
func CreateQueryClusterInfoRequest() (request *QueryClusterInfoRequest) {
	request = &QueryClusterInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "QueryClusterInfo", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryClusterInfoResponse creates a response to parse from QueryClusterInfo response
func CreateQueryClusterInfoResponse() (response *QueryClusterInfoResponse) {
	response = &QueryClusterInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
