package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMseSource invokes the mse.GetMseSource API synchronously
func (client *Client) GetMseSource(request *GetMseSourceRequest) (response *GetMseSourceResponse, err error) {
	response = CreateGetMseSourceResponse()
	err = client.DoAction(request, response)
	return
}

// GetMseSourceWithChan invokes the mse.GetMseSource API asynchronously
func (client *Client) GetMseSourceWithChan(request *GetMseSourceRequest) (<-chan *GetMseSourceResponse, <-chan error) {
	responseChan := make(chan *GetMseSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMseSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMseSourceWithCallback invokes the mse.GetMseSource API asynchronously
func (client *Client) GetMseSourceWithCallback(request *GetMseSourceRequest, callback func(response *GetMseSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMseSourceResponse
		var err error
		defer close(result)
		response, err = client.GetMseSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMseSourceRequest is the request struct for api GetMseSource
type GetMseSourceRequest struct {
	*requests.RpcRequest
	MseSessionId    string `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string `position:"Query" name:"GatewayUniqueId"`
	Type            string `position:"Query" name:"Type"`
	AcceptLanguage  string `position:"Query" name:"AcceptLanguage"`
}

// GetMseSourceResponse is the response struct for api GetMseSource
type GetMseSourceResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string       `json:"Message" xml:"Message"`
	Code           int          `json:"Code" xml:"Code"`
	Success        bool         `json:"Success" xml:"Success"`
	Data           []MseSources `json:"Data" xml:"Data"`
}

// CreateGetMseSourceRequest creates a request to invoke GetMseSource API
func CreateGetMseSourceRequest() (request *GetMseSourceRequest) {
	request = &GetMseSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetMseSource", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMseSourceResponse creates a response to parse from GetMseSource response
func CreateGetMseSourceResponse() (response *GetMseSourceResponse) {
	response = &GetMseSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
