package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMpsSchedulerList invokes the mpaas.QueryMpsSchedulerList API synchronously
func (client *Client) QueryMpsSchedulerList(request *QueryMpsSchedulerListRequest) (response *QueryMpsSchedulerListResponse, err error) {
	response = CreateQueryMpsSchedulerListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMpsSchedulerListWithChan invokes the mpaas.QueryMpsSchedulerList API asynchronously
func (client *Client) QueryMpsSchedulerListWithChan(request *QueryMpsSchedulerListRequest) (<-chan *QueryMpsSchedulerListResponse, <-chan error) {
	responseChan := make(chan *QueryMpsSchedulerListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMpsSchedulerList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMpsSchedulerListWithCallback invokes the mpaas.QueryMpsSchedulerList API asynchronously
func (client *Client) QueryMpsSchedulerListWithCallback(request *QueryMpsSchedulerListRequest, callback func(response *QueryMpsSchedulerListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMpsSchedulerListResponse
		var err error
		defer close(result)
		response, err = client.QueryMpsSchedulerList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMpsSchedulerListRequest is the request struct for api QueryMpsSchedulerList
type QueryMpsSchedulerListRequest struct {
	*requests.RpcRequest
	StartTime   requests.Integer `position:"Body" name:"StartTime"`
	Type        requests.Integer `position:"Body" name:"Type"`
	PageNumber  requests.Integer `position:"Body" name:"PageNumber"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	UniqueId    string           `position:"Body" name:"UniqueId"`
	EndTime     requests.Integer `position:"Body" name:"EndTime"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// QueryMpsSchedulerListResponse is the response struct for api QueryMpsSchedulerList
type QueryMpsSchedulerListResponse struct {
	*responses.BaseResponse
	ResultMessage string        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string        `json:"ResultCode" xml:"ResultCode"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContent `json:"ResultContent" xml:"ResultContent"`
}

// CreateQueryMpsSchedulerListRequest creates a request to invoke QueryMpsSchedulerList API
func CreateQueryMpsSchedulerListRequest() (request *QueryMpsSchedulerListRequest) {
	request = &QueryMpsSchedulerListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "QueryMpsSchedulerList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryMpsSchedulerListResponse creates a response to parse from QueryMpsSchedulerList response
func CreateQueryMpsSchedulerListResponse() (response *QueryMpsSchedulerListResponse) {
	response = &QueryMpsSchedulerListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
