package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushTemplate invokes the mpaas.PushTemplate API synchronously
func (client *Client) PushTemplate(request *PushTemplateRequest) (response *PushTemplateResponse, err error) {
	response = CreatePushTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// PushTemplateWithChan invokes the mpaas.PushTemplate API asynchronously
func (client *Client) PushTemplateWithChan(request *PushTemplateRequest) (<-chan *PushTemplateResponse, <-chan error) {
	responseChan := make(chan *PushTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushTemplateWithCallback invokes the mpaas.PushTemplate API asynchronously
func (client *Client) PushTemplateWithCallback(request *PushTemplateRequest, callback func(response *PushTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushTemplateResponse
		var err error
		defer close(result)
		response, err = client.PushTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushTemplateRequest is the request struct for api PushTemplate
type PushTemplateRequest struct {
	*requests.RpcRequest
	SmsStrategy      requests.Integer `position:"Body" name:"SmsStrategy"`
	TaskName         string           `position:"Body" name:"TaskName"`
	TemplateKeyValue string           `position:"Body" name:"TemplateKeyValue"`
	PushAction       requests.Integer `position:"Body" name:"PushAction"`
	DeliveryType     requests.Integer `position:"Body" name:"DeliveryType"`
	TemplateName     string           `position:"Body" name:"TemplateName"`
	SmsTemplateParam string           `position:"Body" name:"SmsTemplateParam"`
	NotifyType       string           `position:"Body" name:"NotifyType"`
	TargetMsgkey     string           `position:"Body" name:"TargetMsgkey"`
	ExtendedParams   string           `position:"Body" name:"ExtendedParams"`
	Silent           requests.Integer `position:"Body" name:"Silent"`
	StrategyContent  string           `position:"Body" name:"StrategyContent"`
	Classification   string           `position:"Body" name:"Classification"`
	ExpiredSeconds   requests.Integer `position:"Body" name:"ExpiredSeconds"`
	SmsTemplateCode  string           `position:"Body" name:"SmsTemplateCode"`
	AppId            string           `position:"Body" name:"AppId"`
	SmsSignName      string           `position:"Body" name:"SmsSignName"`
	StrategyType     requests.Integer `position:"Body" name:"StrategyType"`
	WorkspaceId      string           `position:"Body" name:"WorkspaceId"`
}

// PushTemplateResponse is the response struct for api PushTemplate
type PushTemplateResponse struct {
	*responses.BaseResponse
	ResultMessage string     `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string     `json:"ResultCode" xml:"ResultCode"`
	RequestId     string     `json:"RequestId" xml:"RequestId"`
	PushResult    PushResult `json:"PushResult" xml:"PushResult"`
}

// CreatePushTemplateRequest creates a request to invoke PushTemplate API
func CreatePushTemplateRequest() (request *PushTemplateRequest) {
	request = &PushTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "PushTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreatePushTemplateResponse creates a response to parse from PushTemplate response
func CreatePushTemplateResponse() (response *PushTemplateResponse) {
	response = &PushTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
