package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOpenSingleData invokes the mpaas.CreateOpenSingleData API synchronously
func (client *Client) CreateOpenSingleData(request *CreateOpenSingleDataRequest) (response *CreateOpenSingleDataResponse, err error) {
	response = CreateCreateOpenSingleDataResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOpenSingleDataWithChan invokes the mpaas.CreateOpenSingleData API asynchronously
func (client *Client) CreateOpenSingleDataWithChan(request *CreateOpenSingleDataRequest) (<-chan *CreateOpenSingleDataResponse, <-chan error) {
	responseChan := make(chan *CreateOpenSingleDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOpenSingleData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOpenSingleDataWithCallback invokes the mpaas.CreateOpenSingleData API asynchronously
func (client *Client) CreateOpenSingleDataWithCallback(request *CreateOpenSingleDataRequest, callback func(response *CreateOpenSingleDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOpenSingleDataResponse
		var err error
		defer close(result)
		response, err = client.CreateOpenSingleData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOpenSingleDataRequest is the request struct for api CreateOpenSingleData
type CreateOpenSingleDataRequest struct {
	*requests.RpcRequest
	ExtAttrStr     string           `position:"Body" name:"ExtAttrStr"`
	ThirdMsgId     string           `position:"Body" name:"ThirdMsgId"`
	ValidTimeEnd   requests.Integer `position:"Body" name:"ValidTimeEnd"`
	Payload        string           `position:"Body" name:"Payload"`
	CheckOnline    requests.Boolean `position:"Body" name:"CheckOnline"`
	AppMinVersion  string           `position:"Body" name:"AppMinVersion"`
	ValidTimeStart requests.Integer `position:"Body" name:"ValidTimeStart"`
	LinkToken      string           `position:"Body" name:"LinkToken"`
	OsType         string           `position:"Body" name:"OsType"`
	BizType        string           `position:"Body" name:"BizType"`
	AppMaxVersion  string           `position:"Body" name:"AppMaxVersion"`
	AppId          string           `position:"Body" name:"AppId"`
	WorkspaceId    string           `position:"Body" name:"WorkspaceId"`
}

// CreateOpenSingleDataResponse is the response struct for api CreateOpenSingleData
type CreateOpenSingleDataResponse struct {
	*responses.BaseResponse
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	Result        bool   `json:"Result" xml:"Result"`
}

// CreateCreateOpenSingleDataRequest creates a request to invoke CreateOpenSingleData API
func CreateCreateOpenSingleDataRequest() (request *CreateOpenSingleDataRequest) {
	request = &CreateOpenSingleDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateOpenSingleData", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateOpenSingleDataResponse creates a response to parse from CreateOpenSingleData response
func CreateCreateOpenSingleDataResponse() (response *CreateOpenSingleDataResponse) {
	response = &CreateOpenSingleDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
