package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMsaEnhance invokes the mpaas.CreateMsaEnhance API synchronously
func (client *Client) CreateMsaEnhance(request *CreateMsaEnhanceRequest) (response *CreateMsaEnhanceResponse, err error) {
	response = CreateCreateMsaEnhanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMsaEnhanceWithChan invokes the mpaas.CreateMsaEnhance API asynchronously
func (client *Client) CreateMsaEnhanceWithChan(request *CreateMsaEnhanceRequest) (<-chan *CreateMsaEnhanceResponse, <-chan error) {
	responseChan := make(chan *CreateMsaEnhanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMsaEnhance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMsaEnhanceWithCallback invokes the mpaas.CreateMsaEnhance API asynchronously
func (client *Client) CreateMsaEnhanceWithCallback(request *CreateMsaEnhanceRequest, callback func(response *CreateMsaEnhanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMsaEnhanceResponse
		var err error
		defer close(result)
		response, err = client.CreateMsaEnhance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMsaEnhanceRequest is the request struct for api CreateMsaEnhance
type CreateMsaEnhanceRequest struct {
	*requests.RpcRequest
	MpaasMappcenterMsaEnhanceCreateJsonStr string `position:"Body" name:"MpaasMappcenterMsaEnhanceCreateJsonStr"`
	TenantId                               string `position:"Body" name:"TenantId"`
	AppId                                  string `position:"Body" name:"AppId"`
	WorkspaceId                            string `position:"Body" name:"WorkspaceId"`
}

// CreateMsaEnhanceResponse is the response struct for api CreateMsaEnhance
type CreateMsaEnhanceResponse struct {
	*responses.BaseResponse
	ResultMessage string                          `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                          `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                          `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInCreateMsaEnhance `json:"ResultContent" xml:"ResultContent"`
}

// CreateCreateMsaEnhanceRequest creates a request to invoke CreateMsaEnhance API
func CreateCreateMsaEnhanceRequest() (request *CreateMsaEnhanceRequest) {
	request = &CreateMsaEnhanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMsaEnhance", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMsaEnhanceResponse creates a response to parse from CreateMsaEnhance response
func CreateCreateMsaEnhanceResponse() (response *CreateMsaEnhanceResponse) {
	response = &CreateMsaEnhanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
