package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMeterLiveRtcDuration invokes the live.DescribeMeterLiveRtcDuration API synchronously
func (client *Client) DescribeMeterLiveRtcDuration(request *DescribeMeterLiveRtcDurationRequest) (response *DescribeMeterLiveRtcDurationResponse, err error) {
	response = CreateDescribeMeterLiveRtcDurationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMeterLiveRtcDurationWithChan invokes the live.DescribeMeterLiveRtcDuration API asynchronously
func (client *Client) DescribeMeterLiveRtcDurationWithChan(request *DescribeMeterLiveRtcDurationRequest) (<-chan *DescribeMeterLiveRtcDurationResponse, <-chan error) {
	responseChan := make(chan *DescribeMeterLiveRtcDurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMeterLiveRtcDuration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMeterLiveRtcDurationWithCallback invokes the live.DescribeMeterLiveRtcDuration API asynchronously
func (client *Client) DescribeMeterLiveRtcDurationWithCallback(request *DescribeMeterLiveRtcDurationRequest, callback func(response *DescribeMeterLiveRtcDurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMeterLiveRtcDurationResponse
		var err error
		defer close(result)
		response, err = client.DescribeMeterLiveRtcDuration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMeterLiveRtcDurationRequest is the request struct for api DescribeMeterLiveRtcDuration
type DescribeMeterLiveRtcDurationRequest struct {
	*requests.RpcRequest
	EndTime     string `position:"Query" name:"EndTime"`
	StartTime   string `position:"Query" name:"StartTime"`
	ServiceArea string `position:"Query" name:"ServiceArea"`
	AppId       string `position:"Query" name:"appId"`
	Interval    string `position:"Query" name:"Interval"`
}

// DescribeMeterLiveRtcDurationResponse is the response struct for api DescribeMeterLiveRtcDuration
type DescribeMeterLiveRtcDurationResponse struct {
	*responses.BaseResponse
	RequestId            string                                   `json:"RequestId" xml:"RequestId"`
	TotalSummaryDuration int64                                    `json:"TotalSummaryDuration" xml:"TotalSummaryDuration"`
	AudioSummaryDuration int64                                    `json:"AudioSummaryDuration" xml:"AudioSummaryDuration"`
	V480SummaryDuration  int64                                    `json:"V480SummaryDuration" xml:"V480SummaryDuration"`
	V720SummaryDuration  int64                                    `json:"V720SummaryDuration" xml:"V720SummaryDuration"`
	V1080SummaryDuration int64                                    `json:"V1080SummaryDuration" xml:"V1080SummaryDuration"`
	Data                 []DataItemInDescribeMeterLiveRtcDuration `json:"Data" xml:"Data"`
}

// CreateDescribeMeterLiveRtcDurationRequest creates a request to invoke DescribeMeterLiveRtcDuration API
func CreateDescribeMeterLiveRtcDurationRequest() (request *DescribeMeterLiveRtcDurationRequest) {
	request = &DescribeMeterLiveRtcDurationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeMeterLiveRtcDuration", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMeterLiveRtcDurationResponse creates a response to parse from DescribeMeterLiveRtcDuration response
func CreateDescribeMeterLiveRtcDurationResponse() (response *DescribeMeterLiveRtcDurationResponse) {
	response = &DescribeMeterLiveRtcDurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
