package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopParser invokes the iot.StopParser API synchronously
func (client *Client) StopParser(request *StopParserRequest) (response *StopParserResponse, err error) {
	response = CreateStopParserResponse()
	err = client.DoAction(request, response)
	return
}

// StopParserWithChan invokes the iot.StopParser API asynchronously
func (client *Client) StopParserWithChan(request *StopParserRequest) (<-chan *StopParserResponse, <-chan error) {
	responseChan := make(chan *StopParserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopParser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopParserWithCallback invokes the iot.StopParser API asynchronously
func (client *Client) StopParserWithCallback(request *StopParserRequest, callback func(response *StopParserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopParserResponse
		var err error
		defer close(result)
		response, err = client.StopParser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopParserRequest is the request struct for api StopParser
type StopParserRequest struct {
	*requests.RpcRequest
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	ParserId      requests.Integer `position:"Query" name:"ParserId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// StopParserResponse is the response struct for api StopParser
type StopParserResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateStopParserRequest creates a request to invoke StopParser API
func CreateStopParserRequest() (request *StopParserRequest) {
	request = &StopParserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "StopParser", "", "")
	request.Method = requests.POST
	return
}

// CreateStopParserResponse creates a response to parse from StopParser response
func CreateStopParserResponse() (response *StopParserResponse) {
	response = &StopParserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
