package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListThingTemplates invokes the iot.ListThingTemplates API synchronously
func (client *Client) ListThingTemplates(request *ListThingTemplatesRequest) (response *ListThingTemplatesResponse, err error) {
	response = CreateListThingTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListThingTemplatesWithChan invokes the iot.ListThingTemplates API asynchronously
func (client *Client) ListThingTemplatesWithChan(request *ListThingTemplatesRequest) (<-chan *ListThingTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListThingTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListThingTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListThingTemplatesWithCallback invokes the iot.ListThingTemplates API asynchronously
func (client *Client) ListThingTemplatesWithCallback(request *ListThingTemplatesRequest, callback func(response *ListThingTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListThingTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListThingTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListThingTemplatesRequest is the request struct for api ListThingTemplates
type ListThingTemplatesRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// ListThingTemplatesResponse is the response struct for api ListThingTemplates
type ListThingTemplatesResponse struct {
	*responses.BaseResponse
	RequestId    string         `json:"RequestId" xml:"RequestId"`
	Success      bool           `json:"Success" xml:"Success"`
	Code         string         `json:"Code" xml:"Code"`
	ErrorMessage string         `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         []CategoryInfo `json:"Data" xml:"Data"`
}

// CreateListThingTemplatesRequest creates a request to invoke ListThingTemplates API
func CreateListThingTemplatesRequest() (request *ListThingTemplatesRequest) {
	request = &ListThingTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListThingTemplates", "", "")
	request.Method = requests.POST
	return
}

// CreateListThingTemplatesResponse creates a response to parse from ListThingTemplates response
func CreateListThingTemplatesResponse() (response *ListThingTemplatesResponse) {
	response = &ListThingTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
