package imageseg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentFace invokes the imageseg.SegmentFace API synchronously
func (client *Client) SegmentFace(request *SegmentFaceRequest) (response *SegmentFaceResponse, err error) {
	response = CreateSegmentFaceResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentFaceWithChan invokes the imageseg.SegmentFace API asynchronously
func (client *Client) SegmentFaceWithChan(request *SegmentFaceRequest) (<-chan *SegmentFaceResponse, <-chan error) {
	responseChan := make(chan *SegmentFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentFaceWithCallback invokes the imageseg.SegmentFace API asynchronously
func (client *Client) SegmentFaceWithCallback(request *SegmentFaceRequest, callback func(response *SegmentFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentFaceResponse
		var err error
		defer close(result)
		response, err = client.SegmentFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentFaceRequest is the request struct for api SegmentFace
type SegmentFaceRequest struct {
	*requests.RpcRequest
	OssFile        string `position:"Query" name:"OssFile"`
	RequestProxyBy string `position:"Query" name:"RequestProxyBy"`
	ImageURL       string `position:"Query" name:"ImageURL"`
}

// SegmentFaceResponse is the response struct for api SegmentFace
type SegmentFaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentFaceRequest creates a request to invoke SegmentFace API
func CreateSegmentFaceRequest() (request *SegmentFaceRequest) {
	request = &SegmentFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageseg", "2019-12-30", "SegmentFace", "", "")
	request.Method = requests.POST
	return
}

// CreateSegmentFaceResponse creates a response to parse from SegmentFace response
func CreateSegmentFaceResponse() (response *SegmentFaceResponse) {
	response = &SegmentFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
