package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ScreenEC invokes the imageprocess.ScreenEC API synchronously
func (client *Client) ScreenEC(request *ScreenECRequest) (response *ScreenECResponse, err error) {
	response = CreateScreenECResponse()
	err = client.DoAction(request, response)
	return
}

// ScreenECWithChan invokes the imageprocess.ScreenEC API asynchronously
func (client *Client) ScreenECWithChan(request *ScreenECRequest) (<-chan *ScreenECResponse, <-chan error) {
	responseChan := make(chan *ScreenECResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ScreenEC(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ScreenECWithCallback invokes the imageprocess.ScreenEC API asynchronously
func (client *Client) ScreenECWithCallback(request *ScreenECRequest, callback func(response *ScreenECResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ScreenECResponse
		var err error
		defer close(result)
		response, err = client.ScreenEC(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ScreenECRequest is the request struct for api ScreenEC
type ScreenECRequest struct {
	*requests.RpcRequest
	DataSourceType string             `position:"Body" name:"DataSourceType"`
	URLList        *[]ScreenECURLList `position:"Body" name:"URLList"  type:"Repeated"`
	Async          requests.Boolean   `position:"Body" name:"Async"`
}

// ScreenECURLList is a repeated param struct in ScreenECRequest
type ScreenECURLList struct {
	URL string `name:"URL"`
}

// ScreenECResponse is the response struct for api ScreenEC
type ScreenECResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateScreenECRequest creates a request to invoke ScreenEC API
func CreateScreenECRequest() (request *ScreenECRequest) {
	request = &ScreenECRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "ScreenEC", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateScreenECResponse creates a response to parse from ScreenEC response
func CreateScreenECResponse() (response *ScreenECResponse) {
	response = &ScreenECResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
