package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLindormInstance invokes the hitsdb.CreateLindormInstance API synchronously
func (client *Client) CreateLindormInstance(request *CreateLindormInstanceRequest) (response *CreateLindormInstanceResponse, err error) {
	response = CreateCreateLindormInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLindormInstanceWithChan invokes the hitsdb.CreateLindormInstance API asynchronously
func (client *Client) CreateLindormInstanceWithChan(request *CreateLindormInstanceRequest) (<-chan *CreateLindormInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateLindormInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLindormInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLindormInstanceWithCallback invokes the hitsdb.CreateLindormInstance API asynchronously
func (client *Client) CreateLindormInstanceWithCallback(request *CreateLindormInstanceRequest, callback func(response *CreateLindormInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLindormInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateLindormInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLindormInstanceRequest is the request struct for api CreateLindormInstance
type CreateLindormInstanceRequest struct {
	*requests.RpcRequest
	ArchVersion          string           `position:"Query" name:"ArchVersion"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	LogSpec              string           `position:"Query" name:"LogSpec"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	TsdbNum              requests.Integer `position:"Query" name:"TsdbNum"`
	PrimaryVSwitchId     string           `position:"Query" name:"PrimaryVSwitchId"`
	SolrNum              requests.Integer `position:"Query" name:"SolrNum"`
	InstanceStorage      string           `position:"Query" name:"InstanceStorage"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	LindormNum           requests.Integer `position:"Query" name:"LindormNum"`
	VSwitchId            string           `position:"Query" name:"VSwitchId"`
	LogSingleStorage     requests.Integer `position:"Query" name:"LogSingleStorage"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
	ArbiterZoneId        string           `position:"Query" name:"ArbiterZoneId"`
	PricingCycle         string           `position:"Query" name:"PricingCycle"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	MultiZoneCombination string           `position:"Query" name:"MultiZoneCombination"`
	TsdbSpec             string           `position:"Query" name:"TsdbSpec"`
	PrimaryZoneId        string           `position:"Query" name:"PrimaryZoneId"`
	FilestoreSpec        string           `position:"Query" name:"FilestoreSpec"`
	Duration             string           `position:"Query" name:"Duration"`
	DiskCategory         string           `position:"Query" name:"DiskCategory"`
	LindormSpec          string           `position:"Query" name:"LindormSpec"`
	ColdStorage          requests.Integer `position:"Query" name:"ColdStorage"`
	LogNum               requests.Integer `position:"Query" name:"LogNum"`
	StandbyVSwitchId     string           `position:"Query" name:"StandbyVSwitchId"`
	SolrSpec             string           `position:"Query" name:"SolrSpec"`
	LogDiskCategory      string           `position:"Query" name:"LogDiskCategory"`
	CoreSingleStorage    requests.Integer `position:"Query" name:"CoreSingleStorage"`
	StandbyZoneId        string           `position:"Query" name:"StandbyZoneId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	InstanceAlias        string           `position:"Query" name:"InstanceAlias"`
	FilestoreNum         requests.Integer `position:"Query" name:"FilestoreNum"`
	CoreSpec             string           `position:"Query" name:"CoreSpec"`
	VPCId                string           `position:"Query" name:"VPCId"`
	PayType              string           `position:"Query" name:"PayType"`
	ArbiterVSwitchId     string           `position:"Query" name:"ArbiterVSwitchId"`
}

// CreateLindormInstanceResponse is the response struct for api CreateLindormInstance
type CreateLindormInstanceResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
	OrderId    int64  `json:"OrderId" xml:"OrderId"`
}

// CreateCreateLindormInstanceRequest creates a request to invoke CreateLindormInstance API
func CreateCreateLindormInstanceRequest() (request *CreateLindormInstanceRequest) {
	request = &CreateLindormInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "CreateLindormInstance", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLindormInstanceResponse creates a response to parse from CreateLindormInstance response
func CreateCreateLindormInstanceResponse() (response *CreateLindormInstanceResponse) {
	response = &CreateLindormInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
