package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEpnInstance invokes the ens.DeleteEpnInstance API synchronously
func (client *Client) DeleteEpnInstance(request *DeleteEpnInstanceRequest) (response *DeleteEpnInstanceResponse, err error) {
	response = CreateDeleteEpnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEpnInstanceWithChan invokes the ens.DeleteEpnInstance API asynchronously
func (client *Client) DeleteEpnInstanceWithChan(request *DeleteEpnInstanceRequest) (<-chan *DeleteEpnInstanceResponse, <-chan error) {
	responseChan := make(chan *DeleteEpnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEpnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEpnInstanceWithCallback invokes the ens.DeleteEpnInstance API asynchronously
func (client *Client) DeleteEpnInstanceWithCallback(request *DeleteEpnInstanceRequest, callback func(response *DeleteEpnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEpnInstanceResponse
		var err error
		defer close(result)
		response, err = client.DeleteEpnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEpnInstanceRequest is the request struct for api DeleteEpnInstance
type DeleteEpnInstanceRequest struct {
	*requests.RpcRequest
	EPNInstanceId string `position:"Query" name:"EPNInstanceId"`
}

// DeleteEpnInstanceResponse is the response struct for api DeleteEpnInstance
type DeleteEpnInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEpnInstanceRequest creates a request to invoke DeleteEpnInstance API
func CreateDeleteEpnInstanceRequest() (request *DeleteEpnInstanceRequest) {
	request = &DeleteEpnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteEpnInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEpnInstanceResponse creates a response to parse from DeleteEpnInstance response
func CreateDeleteEpnInstanceResponse() (response *DeleteEpnInstanceResponse) {
	response = &DeleteEpnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
