package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEnsRouteEntry invokes the ens.CreateEnsRouteEntry API synchronously
func (client *Client) CreateEnsRouteEntry(request *CreateEnsRouteEntryRequest) (response *CreateEnsRouteEntryResponse, err error) {
	response = CreateCreateEnsRouteEntryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEnsRouteEntryWithChan invokes the ens.CreateEnsRouteEntry API asynchronously
func (client *Client) CreateEnsRouteEntryWithChan(request *CreateEnsRouteEntryRequest) (<-chan *CreateEnsRouteEntryResponse, <-chan error) {
	responseChan := make(chan *CreateEnsRouteEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEnsRouteEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEnsRouteEntryWithCallback invokes the ens.CreateEnsRouteEntry API asynchronously
func (client *Client) CreateEnsRouteEntryWithCallback(request *CreateEnsRouteEntryRequest, callback func(response *CreateEnsRouteEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEnsRouteEntryResponse
		var err error
		defer close(result)
		response, err = client.CreateEnsRouteEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEnsRouteEntryRequest is the request struct for api CreateEnsRouteEntry
type CreateEnsRouteEntryRequest struct {
	*requests.RpcRequest
	RouteEntryName       string `position:"Query" name:"RouteEntryName"`
	Description          string `position:"Query" name:"Description"`
	NextHopId            string `position:"Query" name:"NextHopId"`
	NextHopType          string `position:"Query" name:"NextHopType"`
	RouteTableId         string `position:"Query" name:"RouteTableId"`
	DestinationCidrBlock string `position:"Query" name:"DestinationCidrBlock"`
}

// CreateEnsRouteEntryResponse is the response struct for api CreateEnsRouteEntry
type CreateEnsRouteEntryResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	RouteEntryId string `json:"RouteEntryId" xml:"RouteEntryId"`
}

// CreateCreateEnsRouteEntryRequest creates a request to invoke CreateEnsRouteEntry API
func CreateCreateEnsRouteEntryRequest() (request *CreateEnsRouteEntryRequest) {
	request = &CreateEnsRouteEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateEnsRouteEntry", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEnsRouteEntryResponse creates a response to parse from CreateEnsRouteEntry response
func CreateCreateEnsRouteEntryResponse() (response *CreateEnsRouteEntryResponse) {
	response = &CreateEnsRouteEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
