package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SummaryImagesInfo invokes the ehpc.SummaryImagesInfo API synchronously
func (client *Client) SummaryImagesInfo(request *SummaryImagesInfoRequest) (response *SummaryImagesInfoResponse, err error) {
	response = CreateSummaryImagesInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SummaryImagesInfoWithChan invokes the ehpc.SummaryImagesInfo API asynchronously
func (client *Client) SummaryImagesInfoWithChan(request *SummaryImagesInfoRequest) (<-chan *SummaryImagesInfoResponse, <-chan error) {
	responseChan := make(chan *SummaryImagesInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SummaryImagesInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SummaryImagesInfoWithCallback invokes the ehpc.SummaryImagesInfo API asynchronously
func (client *Client) SummaryImagesInfoWithCallback(request *SummaryImagesInfoRequest, callback func(response *SummaryImagesInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SummaryImagesInfoResponse
		var err error
		defer close(result)
		response, err = client.SummaryImagesInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SummaryImagesInfoRequest is the request struct for api SummaryImagesInfo
type SummaryImagesInfoRequest struct {
	*requests.RpcRequest
	ClusterId     string `position:"Query" name:"ClusterId"`
	ContainerType string `position:"Query" name:"ContainerType"`
	ImageName     string `position:"Query" name:"ImageName"`
}

// SummaryImagesInfoResponse is the response struct for api SummaryImagesInfo
type SummaryImagesInfoResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	ImagesInfo string `json:"ImagesInfo" xml:"ImagesInfo"`
}

// CreateSummaryImagesInfoRequest creates a request to invoke SummaryImagesInfo API
func CreateSummaryImagesInfoRequest() (request *SummaryImagesInfoRequest) {
	request = &SummaryImagesInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "SummaryImagesInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateSummaryImagesInfoResponse creates a response to parse from SummaryImagesInfo response
func CreateSummaryImagesInfoResponse() (response *SummaryImagesInfoResponse) {
	response = &SummaryImagesInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
