package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableApplicationScalingRule invokes the edas.DisableApplicationScalingRule API synchronously
func (client *Client) DisableApplicationScalingRule(request *DisableApplicationScalingRuleRequest) (response *DisableApplicationScalingRuleResponse, err error) {
	response = CreateDisableApplicationScalingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DisableApplicationScalingRuleWithChan invokes the edas.DisableApplicationScalingRule API asynchronously
func (client *Client) DisableApplicationScalingRuleWithChan(request *DisableApplicationScalingRuleRequest) (<-chan *DisableApplicationScalingRuleResponse, <-chan error) {
	responseChan := make(chan *DisableApplicationScalingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableApplicationScalingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableApplicationScalingRuleWithCallback invokes the edas.DisableApplicationScalingRule API asynchronously
func (client *Client) DisableApplicationScalingRuleWithCallback(request *DisableApplicationScalingRuleRequest, callback func(response *DisableApplicationScalingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableApplicationScalingRuleResponse
		var err error
		defer close(result)
		response, err = client.DisableApplicationScalingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableApplicationScalingRuleRequest is the request struct for api DisableApplicationScalingRule
type DisableApplicationScalingRuleRequest struct {
	*requests.RoaRequest
	ScalingRuleName string `position:"Query" name:"ScalingRuleName"`
	AppId           string `position:"Query" name:"AppId"`
}

// DisableApplicationScalingRuleResponse is the response struct for api DisableApplicationScalingRule
type DisableApplicationScalingRuleResponse struct {
	*responses.BaseResponse
	Code           int            `json:"Code" xml:"Code"`
	Message        string         `json:"Message" xml:"Message"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	AppScalingRule AppScalingRule `json:"AppScalingRule" xml:"AppScalingRule"`
}

// CreateDisableApplicationScalingRuleRequest creates a request to invoke DisableApplicationScalingRule API
func CreateDisableApplicationScalingRuleRequest() (request *DisableApplicationScalingRuleRequest) {
	request = &DisableApplicationScalingRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DisableApplicationScalingRule", "/pop/v1/eam/scale/disable_application_scaling_rule", "Edas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateDisableApplicationScalingRuleResponse creates a response to parse from DisableApplicationScalingRule response
func CreateDisableApplicationScalingRuleResponse() (response *DisableApplicationScalingRuleResponse) {
	response = &DisableApplicationScalingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
