package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPluginStatus invokes the ecs.ListPluginStatus API synchronously
func (client *Client) ListPluginStatus(request *ListPluginStatusRequest) (response *ListPluginStatusResponse, err error) {
	response = CreateListPluginStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ListPluginStatusWithChan invokes the ecs.ListPluginStatus API asynchronously
func (client *Client) ListPluginStatusWithChan(request *ListPluginStatusRequest) (<-chan *ListPluginStatusResponse, <-chan error) {
	responseChan := make(chan *ListPluginStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPluginStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPluginStatusWithCallback invokes the ecs.ListPluginStatus API asynchronously
func (client *Client) ListPluginStatusWithCallback(request *ListPluginStatusRequest, callback func(response *ListPluginStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPluginStatusResponse
		var err error
		defer close(result)
		response, err = client.ListPluginStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPluginStatusRequest is the request struct for api ListPluginStatus
type ListPluginStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           *[]string        `position:"Query" name:"InstanceId"  type:"Repeated"`
	Name                 string           `position:"Query" name:"Name"`
}

// ListPluginStatusResponse is the response struct for api ListPluginStatus
type ListPluginStatusResponse struct {
	*responses.BaseResponse
	PageSize                int64                   `json:"PageSize" xml:"PageSize"`
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	PageNumber              int64                   `json:"PageNumber" xml:"PageNumber"`
	TotalCount              int64                   `json:"TotalCount" xml:"TotalCount"`
	InstancePluginStatusSet InstancePluginStatusSet `json:"InstancePluginStatusSet" xml:"InstancePluginStatusSet"`
}

// CreateListPluginStatusRequest creates a request to invoke ListPluginStatus API
func CreateListPluginStatusRequest() (request *ListPluginStatusRequest) {
	request = &ListPluginStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ListPluginStatus", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPluginStatusResponse creates a response to parse from ListPluginStatus response
func CreateListPluginStatusResponse() (response *ListPluginStatusResponse) {
	response = &ListPluginStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
