package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSnapshotGroup invokes the ecs.CreateSnapshotGroup API synchronously
func (client *Client) CreateSnapshotGroup(request *CreateSnapshotGroupRequest) (response *CreateSnapshotGroupResponse, err error) {
	response = CreateCreateSnapshotGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSnapshotGroupWithChan invokes the ecs.CreateSnapshotGroup API asynchronously
func (client *Client) CreateSnapshotGroupWithChan(request *CreateSnapshotGroupRequest) (<-chan *CreateSnapshotGroupResponse, <-chan error) {
	responseChan := make(chan *CreateSnapshotGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSnapshotGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSnapshotGroupWithCallback invokes the ecs.CreateSnapshotGroup API asynchronously
func (client *Client) CreateSnapshotGroupWithCallback(request *CreateSnapshotGroupRequest, callback func(response *CreateSnapshotGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSnapshotGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateSnapshotGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSnapshotGroupRequest is the request struct for api CreateSnapshotGroup
type CreateSnapshotGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId            requests.Integer          `position:"Query" name:"ResourceOwnerId"`
	InstantAccess              requests.Boolean          `position:"Query" name:"InstantAccess"`
	ExcludeDiskId              *[]string                 `position:"Query" name:"ExcludeDiskId"  type:"Repeated"`
	Description                string                    `position:"Query" name:"Description"`
	ResourceGroupId            string                    `position:"Query" name:"ResourceGroupId"`
	InstantAccessRetentionDays requests.Integer          `position:"Query" name:"InstantAccessRetentionDays"`
	StorageLocationArn         string                    `position:"Query" name:"StorageLocationArn"`
	DiskId                     *[]string                 `position:"Query" name:"DiskId"  type:"Repeated"`
	Tag                        *[]CreateSnapshotGroupTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount       string                    `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount               string                    `position:"Query" name:"OwnerAccount"`
	OwnerId                    requests.Integer          `position:"Query" name:"OwnerId"`
	InstanceId                 string                    `position:"Query" name:"InstanceId"`
	Name                       string                    `position:"Query" name:"Name"`
}

// CreateSnapshotGroupTag is a repeated param struct in CreateSnapshotGroupRequest
type CreateSnapshotGroupTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateSnapshotGroupResponse is the response struct for api CreateSnapshotGroup
type CreateSnapshotGroupResponse struct {
	*responses.BaseResponse
	SnapshotGroupId string `json:"SnapshotGroupId" xml:"SnapshotGroupId"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateSnapshotGroupRequest creates a request to invoke CreateSnapshotGroup API
func CreateCreateSnapshotGroupRequest() (request *CreateSnapshotGroupRequest) {
	request = &CreateSnapshotGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "CreateSnapshotGroup", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSnapshotGroupResponse creates a response to parse from CreateSnapshotGroup response
func CreateCreateSnapshotGroupResponse() (response *CreateSnapshotGroupResponse) {
	response = &CreateSnapshotGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
