package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNASFileSystems invokes the ecd.DeleteNASFileSystems API synchronously
func (client *Client) DeleteNASFileSystems(request *DeleteNASFileSystemsRequest) (response *DeleteNASFileSystemsResponse, err error) {
	response = CreateDeleteNASFileSystemsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNASFileSystemsWithChan invokes the ecd.DeleteNASFileSystems API asynchronously
func (client *Client) DeleteNASFileSystemsWithChan(request *DeleteNASFileSystemsRequest) (<-chan *DeleteNASFileSystemsResponse, <-chan error) {
	responseChan := make(chan *DeleteNASFileSystemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNASFileSystems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNASFileSystemsWithCallback invokes the ecd.DeleteNASFileSystems API asynchronously
func (client *Client) DeleteNASFileSystemsWithCallback(request *DeleteNASFileSystemsRequest, callback func(response *DeleteNASFileSystemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNASFileSystemsResponse
		var err error
		defer close(result)
		response, err = client.DeleteNASFileSystems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNASFileSystemsRequest is the request struct for api DeleteNASFileSystems
type DeleteNASFileSystemsRequest struct {
	*requests.RpcRequest
	FileSystemId *[]string `position:"Query" name:"FileSystemId"  type:"Repeated"`
}

// DeleteNASFileSystemsResponse is the response struct for api DeleteNASFileSystems
type DeleteNASFileSystemsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNASFileSystemsRequest creates a request to invoke DeleteNASFileSystems API
func CreateDeleteNASFileSystemsRequest() (request *DeleteNASFileSystemsRequest) {
	request = &DeleteNASFileSystemsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DeleteNASFileSystems", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteNASFileSystemsResponse creates a response to parse from DeleteNASFileSystems response
func CreateDeleteNASFileSystemsResponse() (response *DeleteNASFileSystemsResponse) {
	response = &DeleteNASFileSystemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
