package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRAMDirectory invokes the ecd.CreateRAMDirectory API synchronously
func (client *Client) CreateRAMDirectory(request *CreateRAMDirectoryRequest) (response *CreateRAMDirectoryResponse, err error) {
	response = CreateCreateRAMDirectoryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRAMDirectoryWithChan invokes the ecd.CreateRAMDirectory API asynchronously
func (client *Client) CreateRAMDirectoryWithChan(request *CreateRAMDirectoryRequest) (<-chan *CreateRAMDirectoryResponse, <-chan error) {
	responseChan := make(chan *CreateRAMDirectoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRAMDirectory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRAMDirectoryWithCallback invokes the ecd.CreateRAMDirectory API asynchronously
func (client *Client) CreateRAMDirectoryWithCallback(request *CreateRAMDirectoryRequest, callback func(response *CreateRAMDirectoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRAMDirectoryResponse
		var err error
		defer close(result)
		response, err = client.CreateRAMDirectory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRAMDirectoryRequest is the request struct for api CreateRAMDirectory
type CreateRAMDirectoryRequest struct {
	*requests.RpcRequest
	DesktopAccessType    string           `position:"Query" name:"DesktopAccessType"`
	EnableInternetAccess requests.Boolean `position:"Query" name:"EnableInternetAccess"`
	DirectoryName        string           `position:"Query" name:"DirectoryName"`
	VSwitchId            *[]string        `position:"Query" name:"VSwitchId"  type:"Repeated"`
	EnableAdminAccess    requests.Boolean `position:"Query" name:"EnableAdminAccess"`
}

// CreateRAMDirectoryResponse is the response struct for api CreateRAMDirectory
type CreateRAMDirectoryResponse struct {
	*responses.BaseResponse
	DirectoryId string `json:"DirectoryId" xml:"DirectoryId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateRAMDirectoryRequest creates a request to invoke CreateRAMDirectory API
func CreateCreateRAMDirectoryRequest() (request *CreateRAMDirectoryRequest) {
	request = &CreateRAMDirectoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "CreateRAMDirectory", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateRAMDirectoryResponse creates a response to parse from CreateRAMDirectory response
func CreateCreateRAMDirectoryResponse() (response *CreateRAMDirectoryResponse) {
	response = &CreateRAMDirectoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
