package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDedicatedClusterMonitorRule invokes the dts.DescribeDedicatedClusterMonitorRule API synchronously
func (client *Client) DescribeDedicatedClusterMonitorRule(request *DescribeDedicatedClusterMonitorRuleRequest) (response *DescribeDedicatedClusterMonitorRuleResponse, err error) {
	response = CreateDescribeDedicatedClusterMonitorRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDedicatedClusterMonitorRuleWithChan invokes the dts.DescribeDedicatedClusterMonitorRule API asynchronously
func (client *Client) DescribeDedicatedClusterMonitorRuleWithChan(request *DescribeDedicatedClusterMonitorRuleRequest) (<-chan *DescribeDedicatedClusterMonitorRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeDedicatedClusterMonitorRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDedicatedClusterMonitorRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDedicatedClusterMonitorRuleWithCallback invokes the dts.DescribeDedicatedClusterMonitorRule API asynchronously
func (client *Client) DescribeDedicatedClusterMonitorRuleWithCallback(request *DescribeDedicatedClusterMonitorRuleRequest, callback func(response *DescribeDedicatedClusterMonitorRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDedicatedClusterMonitorRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeDedicatedClusterMonitorRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDedicatedClusterMonitorRuleRequest is the request struct for api DescribeDedicatedClusterMonitorRule
type DescribeDedicatedClusterMonitorRuleRequest struct {
	*requests.RpcRequest
	DedicatedClusterId string `position:"Query" name:"DedicatedClusterId"`
	OwnerId            string `position:"Query" name:"OwnerId"`
}

// DescribeDedicatedClusterMonitorRuleResponse is the response struct for api DescribeDedicatedClusterMonitorRule
type DescribeDedicatedClusterMonitorRuleResponse struct {
	*responses.BaseResponse
	HttpStatusCode     string `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	ErrCode            string `json:"ErrCode" xml:"ErrCode"`
	Success            string `json:"Success" xml:"Success"`
	ErrMessage         string `json:"ErrMessage" xml:"ErrMessage"`
	DedicatedClusterId string `json:"DedicatedClusterId" xml:"DedicatedClusterId"`
	NoticeSwitch       string `json:"NoticeSwitch" xml:"NoticeSwitch"`
	DuAlarmThreshold   string `json:"DuAlarmThreshold" xml:"DuAlarmThreshold"`
	CpuAlarmThreshold  string `json:"CpuAlarmThreshold" xml:"CpuAlarmThreshold"`
	MemAlarmThreshold  string `json:"MemAlarmThreshold" xml:"MemAlarmThreshold"`
	DiskAlarmThreshold string `json:"DiskAlarmThreshold" xml:"DiskAlarmThreshold"`
	Phones             string `json:"Phones" xml:"Phones"`
}

// CreateDescribeDedicatedClusterMonitorRuleRequest creates a request to invoke DescribeDedicatedClusterMonitorRule API
func CreateDescribeDedicatedClusterMonitorRuleRequest() (request *DescribeDedicatedClusterMonitorRuleRequest) {
	request = &DescribeDedicatedClusterMonitorRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeDedicatedClusterMonitorRule", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDedicatedClusterMonitorRuleResponse creates a response to parse from DescribeDedicatedClusterMonitorRule response
func CreateDescribeDedicatedClusterMonitorRuleResponse() (response *DescribeDedicatedClusterMonitorRuleResponse) {
	response = &DescribeDedicatedClusterMonitorRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
