package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryOperationAuditInfoList invokes the domain.QueryOperationAuditInfoList API synchronously
func (client *Client) QueryOperationAuditInfoList(request *QueryOperationAuditInfoListRequest) (response *QueryOperationAuditInfoListResponse, err error) {
	response = CreateQueryOperationAuditInfoListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryOperationAuditInfoListWithChan invokes the domain.QueryOperationAuditInfoList API asynchronously
func (client *Client) QueryOperationAuditInfoListWithChan(request *QueryOperationAuditInfoListRequest) (<-chan *QueryOperationAuditInfoListResponse, <-chan error) {
	responseChan := make(chan *QueryOperationAuditInfoListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryOperationAuditInfoList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryOperationAuditInfoListWithCallback invokes the domain.QueryOperationAuditInfoList API asynchronously
func (client *Client) QueryOperationAuditInfoListWithCallback(request *QueryOperationAuditInfoListRequest, callback func(response *QueryOperationAuditInfoListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryOperationAuditInfoListResponse
		var err error
		defer close(result)
		response, err = client.QueryOperationAuditInfoList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryOperationAuditInfoListRequest is the request struct for api QueryOperationAuditInfoList
type QueryOperationAuditInfoListRequest struct {
	*requests.RpcRequest
	AuditStatus requests.Integer `position:"Query" name:"AuditStatus"`
	DomainName  string           `position:"Query" name:"DomainName"`
	PageNum     requests.Integer `position:"Query" name:"PageNum"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	AuditType   requests.Integer `position:"Query" name:"AuditType"`
	Lang        string           `position:"Query" name:"Lang"`
}

// QueryOperationAuditInfoListResponse is the response struct for api QueryOperationAuditInfoList
type QueryOperationAuditInfoListResponse struct {
	*responses.BaseResponse
	PrePage        bool                   `json:"PrePage" xml:"PrePage"`
	CurrentPageNum int                    `json:"CurrentPageNum" xml:"CurrentPageNum"`
	RequestId      string                 `json:"RequestId" xml:"RequestId"`
	PageSize       int                    `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int                    `json:"TotalPageNum" xml:"TotalPageNum"`
	TotalItemNum   int                    `json:"TotalItemNum" xml:"TotalItemNum"`
	NextPage       bool                   `json:"NextPage" xml:"NextPage"`
	Data           []OperationAuditRecord `json:"Data" xml:"Data"`
}

// CreateQueryOperationAuditInfoListRequest creates a request to invoke QueryOperationAuditInfoList API
func CreateQueryOperationAuditInfoListRequest() (request *QueryOperationAuditInfoListRequest) {
	request = &QueryOperationAuditInfoListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "QueryOperationAuditInfoList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryOperationAuditInfoListResponse creates a response to parse from QueryOperationAuditInfoList response
func CreateQueryOperationAuditInfoListResponse() (response *QueryOperationAuditInfoListResponse) {
	response = &QueryOperationAuditInfoListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
