package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSLARules invokes the dms_enterprise.UpdateSLARules API synchronously
func (client *Client) UpdateSLARules(request *UpdateSLARulesRequest) (response *UpdateSLARulesResponse, err error) {
	response = CreateUpdateSLARulesResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSLARulesWithChan invokes the dms_enterprise.UpdateSLARules API asynchronously
func (client *Client) UpdateSLARulesWithChan(request *UpdateSLARulesRequest) (<-chan *UpdateSLARulesResponse, <-chan error) {
	responseChan := make(chan *UpdateSLARulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSLARules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSLARulesWithCallback invokes the dms_enterprise.UpdateSLARules API asynchronously
func (client *Client) UpdateSLARulesWithCallback(request *UpdateSLARulesRequest, callback func(response *UpdateSLARulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSLARulesResponse
		var err error
		defer close(result)
		response, err = client.UpdateSLARules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSLARulesRequest is the request struct for api UpdateSLARules
type UpdateSLARulesRequest struct {
	*requests.RpcRequest
	DagId       requests.Integer             `position:"Query" name:"DagId"`
	Tid         requests.Integer             `position:"Query" name:"Tid"`
	SlaRuleList *[]UpdateSLARulesSlaRuleList `position:"Query" name:"SlaRuleList"  type:"Json"`
}

// UpdateSLARulesSlaRuleList is a repeated param struct in UpdateSLARulesRequest
type UpdateSLARulesSlaRuleList struct {
	IntervalMinutes string `name:"IntervalMinutes"`
	InfoAction      string `name:"InfoAction"`
	DagId           string `name:"DagId"`
	Type            string `name:"Type"`
	NodeId          string `name:"NodeId"`
}

// UpdateSLARulesResponse is the response struct for api UpdateSLARules
type UpdateSLARulesResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateSLARulesRequest creates a request to invoke UpdateSLARules API
func CreateUpdateSLARulesRequest() (request *UpdateSLARulesRequest) {
	request = &UpdateSLARulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "UpdateSLARules", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSLARulesResponse creates a response to parse from UpdateSLARules response
func CreateUpdateSLARulesResponse() (response *UpdateSLARulesResponse) {
	response = &UpdateSLARulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
