package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyBlockStatus invokes the ddoscoo.ModifyBlockStatus API synchronously
func (client *Client) ModifyBlockStatus(request *ModifyBlockStatusRequest) (response *ModifyBlockStatusResponse, err error) {
	response = CreateModifyBlockStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyBlockStatusWithChan invokes the ddoscoo.ModifyBlockStatus API asynchronously
func (client *Client) ModifyBlockStatusWithChan(request *ModifyBlockStatusRequest) (<-chan *ModifyBlockStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyBlockStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyBlockStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyBlockStatusWithCallback invokes the ddoscoo.ModifyBlockStatus API asynchronously
func (client *Client) ModifyBlockStatusWithCallback(request *ModifyBlockStatusRequest, callback func(response *ModifyBlockStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyBlockStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyBlockStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyBlockStatusRequest is the request struct for api ModifyBlockStatus
type ModifyBlockStatusRequest struct {
	*requests.RpcRequest
	Duration   requests.Integer `position:"Query" name:"Duration"`
	SourceIp   string           `position:"Query" name:"SourceIp"`
	Lang       string           `position:"Query" name:"Lang"`
	Lines      *[]string        `position:"Query" name:"Lines"  type:"Repeated"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	Status     string           `position:"Query" name:"Status"`
}

// ModifyBlockStatusResponse is the response struct for api ModifyBlockStatus
type ModifyBlockStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyBlockStatusRequest creates a request to invoke ModifyBlockStatus API
func CreateModifyBlockStatusRequest() (request *ModifyBlockStatusRequest) {
	request = &ModifyBlockStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyBlockStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyBlockStatusResponse creates a response to parse from ModifyBlockStatus response
func CreateModifyBlockStatusResponse() (response *ModifyBlockStatusResponse) {
	response = &ModifyBlockStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
