package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDcdnSLSRealtimeLogDelivery invokes the dcdn.UpdateDcdnSLSRealtimeLogDelivery API synchronously
func (client *Client) UpdateDcdnSLSRealtimeLogDelivery(request *UpdateDcdnSLSRealtimeLogDeliveryRequest) (response *UpdateDcdnSLSRealtimeLogDeliveryResponse, err error) {
	response = CreateUpdateDcdnSLSRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDcdnSLSRealtimeLogDeliveryWithChan invokes the dcdn.UpdateDcdnSLSRealtimeLogDelivery API asynchronously
func (client *Client) UpdateDcdnSLSRealtimeLogDeliveryWithChan(request *UpdateDcdnSLSRealtimeLogDeliveryRequest) (<-chan *UpdateDcdnSLSRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *UpdateDcdnSLSRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDcdnSLSRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDcdnSLSRealtimeLogDeliveryWithCallback invokes the dcdn.UpdateDcdnSLSRealtimeLogDelivery API asynchronously
func (client *Client) UpdateDcdnSLSRealtimeLogDeliveryWithCallback(request *UpdateDcdnSLSRealtimeLogDeliveryRequest, callback func(response *UpdateDcdnSLSRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDcdnSLSRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.UpdateDcdnSLSRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDcdnSLSRealtimeLogDeliveryRequest is the request struct for api UpdateDcdnSLSRealtimeLogDelivery
type UpdateDcdnSLSRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	SLSLogStore  string `position:"Body" name:"SLSLogStore"`
	ProjectName  string `position:"Body" name:"ProjectName"`
	DomainName   string `position:"Body" name:"DomainName"`
	SamplingRate string `position:"Body" name:"SamplingRate"`
	DataCenter   string `position:"Body" name:"DataCenter"`
	SLSProject   string `position:"Body" name:"SLSProject"`
	SLSRegion    string `position:"Body" name:"SLSRegion"`
}

// UpdateDcdnSLSRealtimeLogDeliveryResponse is the response struct for api UpdateDcdnSLSRealtimeLogDelivery
type UpdateDcdnSLSRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string                                    `json:"RequestId" xml:"RequestId"`
	Content   ContentInUpdateDcdnSLSRealtimeLogDelivery `json:"Content" xml:"Content"`
}

// CreateUpdateDcdnSLSRealtimeLogDeliveryRequest creates a request to invoke UpdateDcdnSLSRealtimeLogDelivery API
func CreateUpdateDcdnSLSRealtimeLogDeliveryRequest() (request *UpdateDcdnSLSRealtimeLogDeliveryRequest) {
	request = &UpdateDcdnSLSRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "UpdateDcdnSLSRealtimeLogDelivery", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDcdnSLSRealtimeLogDeliveryResponse creates a response to parse from UpdateDcdnSLSRealtimeLogDelivery response
func CreateUpdateDcdnSLSRealtimeLogDeliveryResponse() (response *UpdateDcdnSLSRealtimeLogDeliveryResponse) {
	response = &UpdateDcdnSLSRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
