package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDcdnSpecificConfig invokes the dcdn.DeleteDcdnSpecificConfig API synchronously
func (client *Client) DeleteDcdnSpecificConfig(request *DeleteDcdnSpecificConfigRequest) (response *DeleteDcdnSpecificConfigResponse, err error) {
	response = CreateDeleteDcdnSpecificConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDcdnSpecificConfigWithChan invokes the dcdn.DeleteDcdnSpecificConfig API asynchronously
func (client *Client) DeleteDcdnSpecificConfigWithChan(request *DeleteDcdnSpecificConfigRequest) (<-chan *DeleteDcdnSpecificConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteDcdnSpecificConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDcdnSpecificConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDcdnSpecificConfigWithCallback invokes the dcdn.DeleteDcdnSpecificConfig API asynchronously
func (client *Client) DeleteDcdnSpecificConfigWithCallback(request *DeleteDcdnSpecificConfigRequest, callback func(response *DeleteDcdnSpecificConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDcdnSpecificConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteDcdnSpecificConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDcdnSpecificConfigRequest is the request struct for api DeleteDcdnSpecificConfig
type DeleteDcdnSpecificConfigRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	ConfigId      string           `position:"Query" name:"ConfigId"`
}

// DeleteDcdnSpecificConfigResponse is the response struct for api DeleteDcdnSpecificConfig
type DeleteDcdnSpecificConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDcdnSpecificConfigRequest creates a request to invoke DeleteDcdnSpecificConfig API
func CreateDeleteDcdnSpecificConfigRequest() (request *DeleteDcdnSpecificConfigRequest) {
	request = &DeleteDcdnSpecificConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DeleteDcdnSpecificConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDcdnSpecificConfigResponse creates a response to parse from DeleteDcdnSpecificConfig response
func CreateDeleteDcdnSpecificConfigResponse() (response *DeleteDcdnSpecificConfigResponse) {
	response = &DeleteDcdnSpecificConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
