package dbs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNodeCidrList invokes the dbs.DescribeNodeCidrList API synchronously
func (client *Client) DescribeNodeCidrList(request *DescribeNodeCidrListRequest) (response *DescribeNodeCidrListResponse, err error) {
	response = CreateDescribeNodeCidrListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNodeCidrListWithChan invokes the dbs.DescribeNodeCidrList API asynchronously
func (client *Client) DescribeNodeCidrListWithChan(request *DescribeNodeCidrListRequest) (<-chan *DescribeNodeCidrListResponse, <-chan error) {
	responseChan := make(chan *DescribeNodeCidrListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNodeCidrList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNodeCidrListWithCallback invokes the dbs.DescribeNodeCidrList API asynchronously
func (client *Client) DescribeNodeCidrListWithCallback(request *DescribeNodeCidrListRequest, callback func(response *DescribeNodeCidrListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNodeCidrListResponse
		var err error
		defer close(result)
		response, err = client.DescribeNodeCidrList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNodeCidrListRequest is the request struct for api DescribeNodeCidrList
type DescribeNodeCidrListRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	OwnerId     string `position:"Query" name:"OwnerId"`
	Region      string `position:"Query" name:"Region"`
}

// DescribeNodeCidrListResponse is the response struct for api DescribeNodeCidrList
type DescribeNodeCidrListResponse struct {
	*responses.BaseResponse
	HttpStatusCode int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	ErrCode        string      `json:"ErrCode" xml:"ErrCode"`
	Success        bool        `json:"Success" xml:"Success"`
	ErrMessage     string      `json:"ErrMessage" xml:"ErrMessage"`
	IntranetIPs    IntranetIPs `json:"IntranetIPs" xml:"IntranetIPs"`
	InternetIPs    InternetIPs `json:"InternetIPs" xml:"InternetIPs"`
}

// CreateDescribeNodeCidrListRequest creates a request to invoke DescribeNodeCidrList API
func CreateDescribeNodeCidrListRequest() (request *DescribeNodeCidrListRequest) {
	request = &DescribeNodeCidrListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dbs", "2019-03-06", "DescribeNodeCidrList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeNodeCidrListResponse creates a response to parse from DescribeNodeCidrList response
func CreateDescribeNodeCidrListResponse() (response *DescribeNodeCidrListResponse) {
	response = &DescribeNodeCidrListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
