package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSnapshot invokes the dbfs.ListSnapshot API synchronously
func (client *Client) ListSnapshot(request *ListSnapshotRequest) (response *ListSnapshotResponse, err error) {
	response = CreateListSnapshotResponse()
	err = client.DoAction(request, response)
	return
}

// ListSnapshotWithChan invokes the dbfs.ListSnapshot API asynchronously
func (client *Client) ListSnapshotWithChan(request *ListSnapshotRequest) (<-chan *ListSnapshotResponse, <-chan error) {
	responseChan := make(chan *ListSnapshotResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSnapshot(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSnapshotWithCallback invokes the dbfs.ListSnapshot API asynchronously
func (client *Client) ListSnapshotWithCallback(request *ListSnapshotRequest, callback func(response *ListSnapshotResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSnapshotResponse
		var err error
		defer close(result)
		response, err = client.ListSnapshot(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSnapshotRequest is the request struct for api ListSnapshot
type ListSnapshotRequest struct {
	*requests.RpcRequest
	SortType     string           `position:"Query" name:"SortType"`
	SnapshotIds  string           `position:"Query" name:"SnapshotIds"`
	FilterValue  string           `position:"Query" name:"FilterValue"`
	SnapshotName string           `position:"Query" name:"SnapshotName"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	FilterKey    string           `position:"Query" name:"FilterKey"`
	SortKey      string           `position:"Query" name:"SortKey"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	FsId         string           `position:"Query" name:"FsId"`
	SnapshotType string           `position:"Query" name:"SnapshotType"`
	Status       string           `position:"Query" name:"Status"`
}

// ListSnapshotResponse is the response struct for api ListSnapshot
type ListSnapshotResponse struct {
	*responses.BaseResponse
	TotalCount int             `json:"TotalCount" xml:"TotalCount"`
	PageSize   int             `json:"PageSize" xml:"PageSize"`
	RequestId  string          `json:"RequestId" xml:"RequestId"`
	PageNumber int             `json:"PageNumber" xml:"PageNumber"`
	Snapshots  []SnapshotsItem `json:"Snapshots" xml:"Snapshots"`
}

// CreateListSnapshotRequest creates a request to invoke ListSnapshot API
func CreateListSnapshotRequest() (request *ListSnapshotRequest) {
	request = &ListSnapshotRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "ListSnapshot", "", "")
	request.Method = requests.POST
	return
}

// CreateListSnapshotResponse creates a response to parse from ListSnapshot response
func CreateListSnapshotResponse() (response *ListSnapshotResponse) {
	response = &ListSnapshotResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
