package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAutoSnapshotPolicyAppliedDbfs invokes the dbfs.ListAutoSnapshotPolicyAppliedDbfs API synchronously
func (client *Client) ListAutoSnapshotPolicyAppliedDbfs(request *ListAutoSnapshotPolicyAppliedDbfsRequest) (response *ListAutoSnapshotPolicyAppliedDbfsResponse, err error) {
	response = CreateListAutoSnapshotPolicyAppliedDbfsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAutoSnapshotPolicyAppliedDbfsWithChan invokes the dbfs.ListAutoSnapshotPolicyAppliedDbfs API asynchronously
func (client *Client) ListAutoSnapshotPolicyAppliedDbfsWithChan(request *ListAutoSnapshotPolicyAppliedDbfsRequest) (<-chan *ListAutoSnapshotPolicyAppliedDbfsResponse, <-chan error) {
	responseChan := make(chan *ListAutoSnapshotPolicyAppliedDbfsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAutoSnapshotPolicyAppliedDbfs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAutoSnapshotPolicyAppliedDbfsWithCallback invokes the dbfs.ListAutoSnapshotPolicyAppliedDbfs API asynchronously
func (client *Client) ListAutoSnapshotPolicyAppliedDbfsWithCallback(request *ListAutoSnapshotPolicyAppliedDbfsRequest, callback func(response *ListAutoSnapshotPolicyAppliedDbfsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAutoSnapshotPolicyAppliedDbfsResponse
		var err error
		defer close(result)
		response, err = client.ListAutoSnapshotPolicyAppliedDbfs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAutoSnapshotPolicyAppliedDbfsRequest is the request struct for api ListAutoSnapshotPolicyAppliedDbfs
type ListAutoSnapshotPolicyAppliedDbfsRequest struct {
	*requests.RpcRequest
	FilterValue string           `position:"Query" name:"FilterValue"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	FilterKey   string           `position:"Query" name:"FilterKey"`
	PolicyId    string           `position:"Query" name:"PolicyId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListAutoSnapshotPolicyAppliedDbfsResponse is the response struct for api ListAutoSnapshotPolicyAppliedDbfs
type ListAutoSnapshotPolicyAppliedDbfsResponse struct {
	*responses.BaseResponse
	PageNumber int            `json:"PageNumber" xml:"PageNumber"`
	PageSize   int            `json:"PageSize" xml:"PageSize"`
	TotalCount int            `json:"TotalCount" xml:"TotalCount"`
	RequestId  string         `json:"RequestId" xml:"RequestId"`
	DbfsList   []DbfsListItem `json:"DbfsList" xml:"DbfsList"`
}

// CreateListAutoSnapshotPolicyAppliedDbfsRequest creates a request to invoke ListAutoSnapshotPolicyAppliedDbfs API
func CreateListAutoSnapshotPolicyAppliedDbfsRequest() (request *ListAutoSnapshotPolicyAppliedDbfsRequest) {
	request = &ListAutoSnapshotPolicyAppliedDbfsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "ListAutoSnapshotPolicyAppliedDbfs", "", "")
	request.Method = requests.POST
	return
}

// CreateListAutoSnapshotPolicyAppliedDbfsResponse creates a response to parse from ListAutoSnapshotPolicyAppliedDbfs response
func CreateListAutoSnapshotPolicyAppliedDbfsResponse() (response *ListAutoSnapshotPolicyAppliedDbfsResponse) {
	response = &ListAutoSnapshotPolicyAppliedDbfsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
