package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAutoSnapshotPolicies invokes the dbfs.ListAutoSnapshotPolicies API synchronously
func (client *Client) ListAutoSnapshotPolicies(request *ListAutoSnapshotPoliciesRequest) (response *ListAutoSnapshotPoliciesResponse, err error) {
	response = CreateListAutoSnapshotPoliciesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAutoSnapshotPoliciesWithChan invokes the dbfs.ListAutoSnapshotPolicies API asynchronously
func (client *Client) ListAutoSnapshotPoliciesWithChan(request *ListAutoSnapshotPoliciesRequest) (<-chan *ListAutoSnapshotPoliciesResponse, <-chan error) {
	responseChan := make(chan *ListAutoSnapshotPoliciesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAutoSnapshotPolicies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAutoSnapshotPoliciesWithCallback invokes the dbfs.ListAutoSnapshotPolicies API asynchronously
func (client *Client) ListAutoSnapshotPoliciesWithCallback(request *ListAutoSnapshotPoliciesRequest, callback func(response *ListAutoSnapshotPoliciesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAutoSnapshotPoliciesResponse
		var err error
		defer close(result)
		response, err = client.ListAutoSnapshotPolicies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAutoSnapshotPoliciesRequest is the request struct for api ListAutoSnapshotPolicies
type ListAutoSnapshotPoliciesRequest struct {
	*requests.RpcRequest
	FilterValue string           `position:"Query" name:"FilterValue"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	FilterKey   string           `position:"Query" name:"FilterKey"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListAutoSnapshotPoliciesResponse is the response struct for api ListAutoSnapshotPolicies
type ListAutoSnapshotPoliciesResponse struct {
	*responses.BaseResponse
	PageNumber       int                    `json:"PageNumber" xml:"PageNumber"`
	PageSize         int                    `json:"PageSize" xml:"PageSize"`
	TotalCount       int                    `json:"TotalCount" xml:"TotalCount"`
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	SnapshotPolicies []SnapshotPoliciesItem `json:"SnapshotPolicies" xml:"SnapshotPolicies"`
}

// CreateListAutoSnapshotPoliciesRequest creates a request to invoke ListAutoSnapshotPolicies API
func CreateListAutoSnapshotPoliciesRequest() (request *ListAutoSnapshotPoliciesRequest) {
	request = &ListAutoSnapshotPoliciesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "ListAutoSnapshotPolicies", "", "")
	request.Method = requests.POST
	return
}

// CreateListAutoSnapshotPoliciesResponse creates a response to parse from ListAutoSnapshotPolicies response
func CreateListAutoSnapshotPoliciesResponse() (response *ListAutoSnapshotPoliciesResponse) {
	response = &ListAutoSnapshotPoliciesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
