package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateBaseline invokes the dataworks_public.UpdateBaseline API synchronously
func (client *Client) UpdateBaseline(request *UpdateBaselineRequest) (response *UpdateBaselineResponse, err error) {
	response = CreateUpdateBaselineResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateBaselineWithChan invokes the dataworks_public.UpdateBaseline API asynchronously
func (client *Client) UpdateBaselineWithChan(request *UpdateBaselineRequest) (<-chan *UpdateBaselineResponse, <-chan error) {
	responseChan := make(chan *UpdateBaselineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateBaseline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateBaselineWithCallback invokes the dataworks_public.UpdateBaseline API asynchronously
func (client *Client) UpdateBaselineWithCallback(request *UpdateBaselineRequest, callback func(response *UpdateBaselineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateBaselineResponse
		var err error
		defer close(result)
		response, err = client.UpdateBaseline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateBaselineRequest is the request struct for api UpdateBaseline
type UpdateBaselineRequest struct {
	*requests.RpcRequest
	Owner                string                            `position:"Body" name:"Owner"`
	RemoveNodeIds        string                            `position:"Body" name:"RemoveNodeIds"`
	AlertMarginThreshold requests.Integer                  `position:"Body" name:"AlertMarginThreshold"`
	OvertimeSettings     *[]UpdateBaselineOvertimeSettings `position:"Body" name:"OvertimeSettings"  type:"Json"`
	Priority             requests.Integer                  `position:"Body" name:"Priority"`
	BaselineId           requests.Integer                  `position:"Body" name:"BaselineId"`
	Enabled              requests.Boolean                  `position:"Body" name:"Enabled"`
	BaselineType         string                            `position:"Body" name:"BaselineType"`
	AlertEnabled         requests.Boolean                  `position:"Body" name:"AlertEnabled"`
	AlertSettings        *[]UpdateBaselineAlertSettings    `position:"Body" name:"AlertSettings"  type:"Json"`
	BaselineName         string                            `position:"Body" name:"BaselineName"`
	ProjectId            requests.Integer                  `position:"Body" name:"ProjectId"`
	NodeIds              string                            `position:"Body" name:"NodeIds"`
}

// UpdateBaselineOvertimeSettings is a repeated param struct in UpdateBaselineRequest
type UpdateBaselineOvertimeSettings struct {
	Time  string `name:"Time"`
	Cycle string `name:"Cycle"`
}

// UpdateBaselineAlertSettings is a repeated param struct in UpdateBaselineRequest
type UpdateBaselineAlertSettings struct {
	DingRobots           *[]UpdateBaselineAlertSettingsDingRobotsItem `name:"DingRobots" type:"Repeated"`
	AlertType            string                                       `name:"AlertType"`
	AlertMaximum         string                                       `name:"AlertMaximum"`
	SilenceStartTime     string                                       `name:"SilenceStartTime"`
	Webhooks             *[]string                                    `name:"Webhooks" type:"Repeated"`
	BaselineAlertEnabled string                                       `name:"BaselineAlertEnabled"`
	AlertRecipientType   string                                       `name:"AlertRecipientType"`
	AlertInterval        string                                       `name:"AlertInterval"`
	TopicTypes           *[]string                                    `name:"TopicTypes" type:"Repeated"`
	AlertRecipient       string                                       `name:"AlertRecipient"`
	AlertMethods         *[]string                                    `name:"AlertMethods" type:"Repeated"`
	SilenceEndTime       string                                       `name:"SilenceEndTime"`
}

// UpdateBaselineAlertSettingsDingRobotsItem is a repeated param struct in UpdateBaselineRequest
type UpdateBaselineAlertSettingsDingRobotsItem struct {
	AtAll  string `name:"AtAll"`
	WebUrl string `name:"WebUrl"`
}

// UpdateBaselineResponse is the response struct for api UpdateBaseline
type UpdateBaselineResponse struct {
	*responses.BaseResponse
	Success             bool   `json:"Success" xml:"Success"`
	ErrorCode           string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage        string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode      int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data                bool   `json:"Data" xml:"Data"`
	RequestId           string `json:"RequestId" xml:"RequestId"`
	DynamicErrorCode    string `json:"DynamicErrorCode" xml:"DynamicErrorCode"`
	DynamicErrorMessage string `json:"DynamicErrorMessage" xml:"DynamicErrorMessage"`
}

// CreateUpdateBaselineRequest creates a request to invoke UpdateBaseline API
func CreateUpdateBaselineRequest() (request *UpdateBaselineRequest) {
	request = &UpdateBaselineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateBaseline", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateBaselineResponse creates a response to parse from UpdateBaseline response
func CreateUpdateBaselineResponse() (response *UpdateBaselineResponse) {
	response = &UpdateBaselineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
