package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokeColumnPermission invokes the dataworks_public.RevokeColumnPermission API synchronously
func (client *Client) RevokeColumnPermission(request *RevokeColumnPermissionRequest) (response *RevokeColumnPermissionResponse, err error) {
	response = CreateRevokeColumnPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// RevokeColumnPermissionWithChan invokes the dataworks_public.RevokeColumnPermission API asynchronously
func (client *Client) RevokeColumnPermissionWithChan(request *RevokeColumnPermissionRequest) (<-chan *RevokeColumnPermissionResponse, <-chan error) {
	responseChan := make(chan *RevokeColumnPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokeColumnPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokeColumnPermissionWithCallback invokes the dataworks_public.RevokeColumnPermission API asynchronously
func (client *Client) RevokeColumnPermissionWithCallback(request *RevokeColumnPermissionRequest, callback func(response *RevokeColumnPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokeColumnPermissionResponse
		var err error
		defer close(result)
		response, err = client.RevokeColumnPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokeColumnPermissionRequest is the request struct for api RevokeColumnPermission
type RevokeColumnPermissionRequest struct {
	*requests.RpcRequest
	RevokeUserName        string           `position:"Query" name:"RevokeUserName"`
	MaxComputeProjectName string           `position:"Query" name:"MaxComputeProjectName"`
	Columns               string           `position:"Query" name:"Columns"`
	RevokeUserId          string           `position:"Query" name:"RevokeUserId"`
	TableName             string           `position:"Query" name:"TableName"`
	WorkspaceId           requests.Integer `position:"Query" name:"WorkspaceId"`
}

// RevokeColumnPermissionResponse is the response struct for api RevokeColumnPermission
type RevokeColumnPermissionResponse struct {
	*responses.BaseResponse
	RevokeSuccess bool   `json:"RevokeSuccess" xml:"RevokeSuccess"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateRevokeColumnPermissionRequest creates a request to invoke RevokeColumnPermission API
func CreateRevokeColumnPermissionRequest() (request *RevokeColumnPermissionRequest) {
	request = &RevokeColumnPermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "RevokeColumnPermission", "", "")
	request.Method = requests.POST
	return
}

// CreateRevokeColumnPermissionResponse creates a response to parse from RevokeColumnPermission response
func CreateRevokeColumnPermissionResponse() (response *RevokeColumnPermissionResponse) {
	response = &RevokeColumnPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
