package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishDataServiceApi invokes the dataworks_public.PublishDataServiceApi API synchronously
func (client *Client) PublishDataServiceApi(request *PublishDataServiceApiRequest) (response *PublishDataServiceApiResponse, err error) {
	response = CreatePublishDataServiceApiResponse()
	err = client.DoAction(request, response)
	return
}

// PublishDataServiceApiWithChan invokes the dataworks_public.PublishDataServiceApi API asynchronously
func (client *Client) PublishDataServiceApiWithChan(request *PublishDataServiceApiRequest) (<-chan *PublishDataServiceApiResponse, <-chan error) {
	responseChan := make(chan *PublishDataServiceApiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishDataServiceApi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishDataServiceApiWithCallback invokes the dataworks_public.PublishDataServiceApi API asynchronously
func (client *Client) PublishDataServiceApiWithCallback(request *PublishDataServiceApiRequest, callback func(response *PublishDataServiceApiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishDataServiceApiResponse
		var err error
		defer close(result)
		response, err = client.PublishDataServiceApi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishDataServiceApiRequest is the request struct for api PublishDataServiceApi
type PublishDataServiceApiRequest struct {
	*requests.RpcRequest
	TenantId  requests.Integer `position:"Body" name:"TenantId"`
	ProjectId requests.Integer `position:"Body" name:"ProjectId"`
	ApiId     requests.Integer `position:"Body" name:"ApiId"`
}

// PublishDataServiceApiResponse is the response struct for api PublishDataServiceApi
type PublishDataServiceApiResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           bool   `json:"Data" xml:"Data"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreatePublishDataServiceApiRequest creates a request to invoke PublishDataServiceApi API
func CreatePublishDataServiceApiRequest() (request *PublishDataServiceApiRequest) {
	request = &PublishDataServiceApiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "PublishDataServiceApi", "", "")
	request.Method = requests.POST
	return
}

// CreatePublishDataServiceApiResponse creates a response to parse from PublishDataServiceApi response
func CreatePublishDataServiceApiResponse() (response *PublishDataServiceApiResponse) {
	response = &PublishDataServiceApiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
