package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataServiceApiTest invokes the dataworks_public.ListDataServiceApiTest API synchronously
func (client *Client) ListDataServiceApiTest(request *ListDataServiceApiTestRequest) (response *ListDataServiceApiTestResponse, err error) {
	response = CreateListDataServiceApiTestResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataServiceApiTestWithChan invokes the dataworks_public.ListDataServiceApiTest API asynchronously
func (client *Client) ListDataServiceApiTestWithChan(request *ListDataServiceApiTestRequest) (<-chan *ListDataServiceApiTestResponse, <-chan error) {
	responseChan := make(chan *ListDataServiceApiTestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataServiceApiTest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataServiceApiTestWithCallback invokes the dataworks_public.ListDataServiceApiTest API asynchronously
func (client *Client) ListDataServiceApiTestWithCallback(request *ListDataServiceApiTestRequest, callback func(response *ListDataServiceApiTestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataServiceApiTestResponse
		var err error
		defer close(result)
		response, err = client.ListDataServiceApiTest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataServiceApiTestRequest is the request struct for api ListDataServiceApiTest
type ListDataServiceApiTestRequest struct {
	*requests.RpcRequest
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	ApiId    requests.Integer `position:"Query" name:"ApiId"`
}

// ListDataServiceApiTestResponse is the response struct for api ListDataServiceApiTest
type ListDataServiceApiTestResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListDataServiceApiTestRequest creates a request to invoke ListDataServiceApiTest API
func CreateListDataServiceApiTestRequest() (request *ListDataServiceApiTestRequest) {
	request = &ListDataServiceApiTestRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListDataServiceApiTest", "", "")
	request.Method = requests.GET
	return
}

// CreateListDataServiceApiTestResponse creates a response to parse from ListDataServiceApiTest response
func CreateListDataServiceApiTestResponse() (response *ListDataServiceApiTestResponse) {
	response = &ListDataServiceApiTestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
