package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAggregateConfigDeliveryChannel invokes the config.DeleteAggregateConfigDeliveryChannel API synchronously
func (client *Client) DeleteAggregateConfigDeliveryChannel(request *DeleteAggregateConfigDeliveryChannelRequest) (response *DeleteAggregateConfigDeliveryChannelResponse, err error) {
	response = CreateDeleteAggregateConfigDeliveryChannelResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAggregateConfigDeliveryChannelWithChan invokes the config.DeleteAggregateConfigDeliveryChannel API asynchronously
func (client *Client) DeleteAggregateConfigDeliveryChannelWithChan(request *DeleteAggregateConfigDeliveryChannelRequest) (<-chan *DeleteAggregateConfigDeliveryChannelResponse, <-chan error) {
	responseChan := make(chan *DeleteAggregateConfigDeliveryChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAggregateConfigDeliveryChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAggregateConfigDeliveryChannelWithCallback invokes the config.DeleteAggregateConfigDeliveryChannel API asynchronously
func (client *Client) DeleteAggregateConfigDeliveryChannelWithCallback(request *DeleteAggregateConfigDeliveryChannelRequest, callback func(response *DeleteAggregateConfigDeliveryChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAggregateConfigDeliveryChannelResponse
		var err error
		defer close(result)
		response, err = client.DeleteAggregateConfigDeliveryChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAggregateConfigDeliveryChannelRequest is the request struct for api DeleteAggregateConfigDeliveryChannel
type DeleteAggregateConfigDeliveryChannelRequest struct {
	*requests.RpcRequest
	AggregatorId      string `position:"Query" name:"AggregatorId"`
	DeliveryChannelId string `position:"Query" name:"DeliveryChannelId"`
}

// DeleteAggregateConfigDeliveryChannelResponse is the response struct for api DeleteAggregateConfigDeliveryChannel
type DeleteAggregateConfigDeliveryChannelResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	DeliveryChannelId string `json:"DeliveryChannelId" xml:"DeliveryChannelId"`
}

// CreateDeleteAggregateConfigDeliveryChannelRequest creates a request to invoke DeleteAggregateConfigDeliveryChannel API
func CreateDeleteAggregateConfigDeliveryChannelRequest() (request *DeleteAggregateConfigDeliveryChannelRequest) {
	request = &DeleteAggregateConfigDeliveryChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "DeleteAggregateConfigDeliveryChannel", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteAggregateConfigDeliveryChannelResponse creates a response to parse from DeleteAggregateConfigDeliveryChannel response
func CreateDeleteAggregateConfigDeliveryChannelResponse() (response *DeleteAggregateConfigDeliveryChannelResponse) {
	response = &DeleteAggregateConfigDeliveryChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
