package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveUsersEx invokes the cloudcallcenter.RemoveUsersEx API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removeusersex.html
func (client *Client) RemoveUsersEx(request *RemoveUsersExRequest) (response *RemoveUsersExResponse, err error) {
	response = CreateRemoveUsersExResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveUsersExWithChan invokes the cloudcallcenter.RemoveUsersEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removeusersex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveUsersExWithChan(request *RemoveUsersExRequest) (<-chan *RemoveUsersExResponse, <-chan error) {
	responseChan := make(chan *RemoveUsersExResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveUsersEx(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveUsersExWithCallback invokes the cloudcallcenter.RemoveUsersEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removeusersex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveUsersExWithCallback(request *RemoveUsersExRequest, callback func(response *RemoveUsersExResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveUsersExResponse
		var err error
		defer close(result)
		response, err = client.RemoveUsersEx(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveUsersExRequest is the request struct for api RemoveUsersEx
type RemoveUsersExRequest struct {
	*requests.RpcRequest
	InstanceId string    `position:"Query" name:"InstanceId"`
	UserId     *[]string `position:"Query" name:"UserId"  type:"Repeated"`
}

// RemoveUsersExResponse is the response struct for api RemoveUsersEx
type RemoveUsersExResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateRemoveUsersExRequest creates a request to invoke RemoveUsersEx API
func CreateRemoveUsersExRequest() (request *RemoveUsersExRequest) {
	request = &RemoveUsersExRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "RemoveUsersEx", "", "")
	request.Method = requests.POST
	return
}

// CreateRemoveUsersExResponse creates a response to parse from RemoveUsersEx response
func CreateRemoveUsersExResponse() (response *RemoveUsersExResponse) {
	response = &RemoveUsersExResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
