package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnReportList invokes the cdn.DescribeCdnReportList API synchronously
func (client *Client) DescribeCdnReportList(request *DescribeCdnReportListRequest) (response *DescribeCdnReportListResponse, err error) {
	response = CreateDescribeCdnReportListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnReportListWithChan invokes the cdn.DescribeCdnReportList API asynchronously
func (client *Client) DescribeCdnReportListWithChan(request *DescribeCdnReportListRequest) (<-chan *DescribeCdnReportListResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnReportListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnReportList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnReportListWithCallback invokes the cdn.DescribeCdnReportList API asynchronously
func (client *Client) DescribeCdnReportListWithCallback(request *DescribeCdnReportListRequest, callback func(response *DescribeCdnReportListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnReportListResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnReportList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnReportListRequest is the request struct for api DescribeCdnReportList
type DescribeCdnReportListRequest struct {
	*requests.RpcRequest
	ReportId requests.Integer `position:"Query" name:"ReportId"`
}

// DescribeCdnReportListResponse is the response struct for api DescribeCdnReportList
type DescribeCdnReportListResponse struct {
	*responses.BaseResponse
	Content   string `json:"Content" xml:"Content"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeCdnReportListRequest creates a request to invoke DescribeCdnReportList API
func CreateDescribeCdnReportListRequest() (request *DescribeCdnReportListRequest) {
	request = &DescribeCdnReportListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeCdnReportList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCdnReportListResponse creates a response to parse from DescribeCdnReportList response
func CreateDescribeCdnReportListResponse() (response *DescribeCdnReportListResponse) {
	response = &DescribeCdnReportListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
