package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportAdmins invokes the ccc.ImportAdmins API synchronously
func (client *Client) ImportAdmins(request *ImportAdminsRequest) (response *ImportAdminsResponse, err error) {
	response = CreateImportAdminsResponse()
	err = client.DoAction(request, response)
	return
}

// ImportAdminsWithChan invokes the ccc.ImportAdmins API asynchronously
func (client *Client) ImportAdminsWithChan(request *ImportAdminsRequest) (<-chan *ImportAdminsResponse, <-chan error) {
	responseChan := make(chan *ImportAdminsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportAdmins(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportAdminsWithCallback invokes the ccc.ImportAdmins API asynchronously
func (client *Client) ImportAdminsWithCallback(request *ImportAdminsRequest, callback func(response *ImportAdminsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportAdminsResponse
		var err error
		defer close(result)
		response, err = client.ImportAdmins(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportAdminsRequest is the request struct for api ImportAdmins
type ImportAdminsRequest struct {
	*requests.RpcRequest
	RamIdList  string `position:"Query" name:"RamIdList"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ImportAdminsResponse is the response struct for api ImportAdmins
type ImportAdminsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	Data           []User `json:"Data" xml:"Data"`
}

// CreateImportAdminsRequest creates a request to invoke ImportAdmins API
func CreateImportAdminsRequest() (request *ImportAdminsRequest) {
	request = &ImportAdminsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ImportAdmins", "", "")
	request.Method = requests.POST
	return
}

// CreateImportAdminsResponse creates a response to parse from ImportAdmins response
func CreateImportAdminsResponse() (response *ImportAdminsResponse) {
	response = &ImportAdminsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
