package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIoTCloudConnectorBackhaulRoute invokes the cc5g.CreateIoTCloudConnectorBackhaulRoute API synchronously
func (client *Client) CreateIoTCloudConnectorBackhaulRoute(request *CreateIoTCloudConnectorBackhaulRouteRequest) (response *CreateIoTCloudConnectorBackhaulRouteResponse, err error) {
	response = CreateCreateIoTCloudConnectorBackhaulRouteResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIoTCloudConnectorBackhaulRouteWithChan invokes the cc5g.CreateIoTCloudConnectorBackhaulRoute API asynchronously
func (client *Client) CreateIoTCloudConnectorBackhaulRouteWithChan(request *CreateIoTCloudConnectorBackhaulRouteRequest) (<-chan *CreateIoTCloudConnectorBackhaulRouteResponse, <-chan error) {
	responseChan := make(chan *CreateIoTCloudConnectorBackhaulRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIoTCloudConnectorBackhaulRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIoTCloudConnectorBackhaulRouteWithCallback invokes the cc5g.CreateIoTCloudConnectorBackhaulRoute API asynchronously
func (client *Client) CreateIoTCloudConnectorBackhaulRouteWithCallback(request *CreateIoTCloudConnectorBackhaulRouteRequest, callback func(response *CreateIoTCloudConnectorBackhaulRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIoTCloudConnectorBackhaulRouteResponse
		var err error
		defer close(result)
		response, err = client.CreateIoTCloudConnectorBackhaulRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIoTCloudConnectorBackhaulRouteRequest is the request struct for api CreateIoTCloudConnectorBackhaulRoute
type CreateIoTCloudConnectorBackhaulRouteRequest struct {
	*requests.RpcRequest
	DryRun                   requests.Boolean `position:"Query" name:"DryRun"`
	NetLinkId                string           `position:"Query" name:"NetLinkId"`
	ClientToken              string           `position:"Query" name:"ClientToken"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
}

// CreateIoTCloudConnectorBackhaulRouteResponse is the response struct for api CreateIoTCloudConnectorBackhaulRoute
type CreateIoTCloudConnectorBackhaulRouteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateIoTCloudConnectorBackhaulRouteRequest creates a request to invoke CreateIoTCloudConnectorBackhaulRoute API
func CreateCreateIoTCloudConnectorBackhaulRouteRequest() (request *CreateIoTCloudConnectorBackhaulRouteRequest) {
	request = &CreateIoTCloudConnectorBackhaulRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "CreateIoTCloudConnectorBackhaulRoute", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateIoTCloudConnectorBackhaulRouteResponse creates a response to parse from CreateIoTCloudConnectorBackhaulRoute response
func CreateCreateIoTCloudConnectorBackhaulRouteResponse() (response *CreateIoTCloudConnectorBackhaulRouteResponse) {
	response = &CreateIoTCloudConnectorBackhaulRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
