package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTransitRouterCidrAllocation invokes the cbn.ListTransitRouterCidrAllocation API synchronously
func (client *Client) ListTransitRouterCidrAllocation(request *ListTransitRouterCidrAllocationRequest) (response *ListTransitRouterCidrAllocationResponse, err error) {
	response = CreateListTransitRouterCidrAllocationResponse()
	err = client.DoAction(request, response)
	return
}

// ListTransitRouterCidrAllocationWithChan invokes the cbn.ListTransitRouterCidrAllocation API asynchronously
func (client *Client) ListTransitRouterCidrAllocationWithChan(request *ListTransitRouterCidrAllocationRequest) (<-chan *ListTransitRouterCidrAllocationResponse, <-chan error) {
	responseChan := make(chan *ListTransitRouterCidrAllocationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTransitRouterCidrAllocation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTransitRouterCidrAllocationWithCallback invokes the cbn.ListTransitRouterCidrAllocation API asynchronously
func (client *Client) ListTransitRouterCidrAllocationWithCallback(request *ListTransitRouterCidrAllocationRequest, callback func(response *ListTransitRouterCidrAllocationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTransitRouterCidrAllocationResponse
		var err error
		defer close(result)
		response, err = client.ListTransitRouterCidrAllocation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTransitRouterCidrAllocationRequest is the request struct for api ListTransitRouterCidrAllocation
type ListTransitRouterCidrAllocationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	TransitRouterCidrId  string           `position:"Query" name:"TransitRouterCidrId"`
	NextToken            string           `position:"Query" name:"NextToken"`
	Cidr                 string           `position:"Query" name:"Cidr"`
	DedicatedOwnerId     string           `position:"Query" name:"DedicatedOwnerId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterId      string           `position:"Query" name:"TransitRouterId"`
	AttachmentName       string           `position:"Query" name:"AttachmentName"`
	Version              string           `position:"Query" name:"Version"`
	CidrBlock            string           `position:"Query" name:"CidrBlock"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
	AttachmentId         string           `position:"Query" name:"AttachmentId"`
}

// ListTransitRouterCidrAllocationResponse is the response struct for api ListTransitRouterCidrAllocation
type ListTransitRouterCidrAllocationResponse struct {
	*responses.BaseResponse
	NextToken                    string                        `json:"NextToken" xml:"NextToken"`
	RequestId                    string                        `json:"RequestId" xml:"RequestId"`
	TotalCount                   int                           `json:"TotalCount" xml:"TotalCount"`
	MaxResults                   int                           `json:"MaxResults" xml:"MaxResults"`
	TransitRouterCidrAllocations []TransitRouterCidrAllocation `json:"TransitRouterCidrAllocations" xml:"TransitRouterCidrAllocations"`
}

// CreateListTransitRouterCidrAllocationRequest creates a request to invoke ListTransitRouterCidrAllocation API
func CreateListTransitRouterCidrAllocationRequest() (request *ListTransitRouterCidrAllocationRequest) {
	request = &ListTransitRouterCidrAllocationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ListTransitRouterCidrAllocation", "", "")
	request.Method = requests.POST
	return
}

// CreateListTransitRouterCidrAllocationResponse creates a response to parse from ListTransitRouterCidrAllocation response
func CreateListTransitRouterCidrAllocationResponse() (response *ListTransitRouterCidrAllocationResponse) {
	response = &ListTransitRouterCidrAllocationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
