package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeregisterTransitRouterMulticastGroupMembers invokes the cbn.DeregisterTransitRouterMulticastGroupMembers API synchronously
func (client *Client) DeregisterTransitRouterMulticastGroupMembers(request *DeregisterTransitRouterMulticastGroupMembersRequest) (response *DeregisterTransitRouterMulticastGroupMembersResponse, err error) {
	response = CreateDeregisterTransitRouterMulticastGroupMembersResponse()
	err = client.DoAction(request, response)
	return
}

// DeregisterTransitRouterMulticastGroupMembersWithChan invokes the cbn.DeregisterTransitRouterMulticastGroupMembers API asynchronously
func (client *Client) DeregisterTransitRouterMulticastGroupMembersWithChan(request *DeregisterTransitRouterMulticastGroupMembersRequest) (<-chan *DeregisterTransitRouterMulticastGroupMembersResponse, <-chan error) {
	responseChan := make(chan *DeregisterTransitRouterMulticastGroupMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeregisterTransitRouterMulticastGroupMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeregisterTransitRouterMulticastGroupMembersWithCallback invokes the cbn.DeregisterTransitRouterMulticastGroupMembers API asynchronously
func (client *Client) DeregisterTransitRouterMulticastGroupMembersWithCallback(request *DeregisterTransitRouterMulticastGroupMembersRequest, callback func(response *DeregisterTransitRouterMulticastGroupMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeregisterTransitRouterMulticastGroupMembersResponse
		var err error
		defer close(result)
		response, err = client.DeregisterTransitRouterMulticastGroupMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeregisterTransitRouterMulticastGroupMembersRequest is the request struct for api DeregisterTransitRouterMulticastGroupMembers
type DeregisterTransitRouterMulticastGroupMembersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                   requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                       string           `position:"Query" name:"ClientToken"`
	NetworkInterfaceIds               *[]string        `position:"Query" name:"NetworkInterfaceIds"  type:"Repeated"`
	TransitRouterMulticastDomainId    string           `position:"Query" name:"TransitRouterMulticastDomainId"`
	ConnectPeerIds                    *[]string        `position:"Query" name:"ConnectPeerIds"  type:"Repeated"`
	GroupIpAddress                    string           `position:"Query" name:"GroupIpAddress"`
	DryRun                            requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount              string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                      string           `position:"Query" name:"OwnerAccount"`
	PeerTransitRouterMulticastDomains *[]string        `position:"Query" name:"PeerTransitRouterMulticastDomains"  type:"Repeated"`
	OwnerId                           requests.Integer `position:"Query" name:"OwnerId"`
	Version                           string           `position:"Query" name:"Version"`
}

// DeregisterTransitRouterMulticastGroupMembersResponse is the response struct for api DeregisterTransitRouterMulticastGroupMembers
type DeregisterTransitRouterMulticastGroupMembersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeregisterTransitRouterMulticastGroupMembersRequest creates a request to invoke DeregisterTransitRouterMulticastGroupMembers API
func CreateDeregisterTransitRouterMulticastGroupMembersRequest() (request *DeregisterTransitRouterMulticastGroupMembersRequest) {
	request = &DeregisterTransitRouterMulticastGroupMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DeregisterTransitRouterMulticastGroupMembers", "", "")
	request.Method = requests.POST
	return
}

// CreateDeregisterTransitRouterMulticastGroupMembersResponse creates a response to parse from DeregisterTransitRouterMulticastGroupMembers response
func CreateDeregisterTransitRouterMulticastGroupMembersResponse() (response *DeregisterTransitRouterMulticastGroupMembersResponse) {
	response = &DeregisterTransitRouterMulticastGroupMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
