package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TurnOnSecondSwitch invokes the arms.TurnOnSecondSwitch API synchronously
func (client *Client) TurnOnSecondSwitch(request *TurnOnSecondSwitchRequest) (response *TurnOnSecondSwitchResponse, err error) {
	response = CreateTurnOnSecondSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// TurnOnSecondSwitchWithChan invokes the arms.TurnOnSecondSwitch API asynchronously
func (client *Client) TurnOnSecondSwitchWithChan(request *TurnOnSecondSwitchRequest) (<-chan *TurnOnSecondSwitchResponse, <-chan error) {
	responseChan := make(chan *TurnOnSecondSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TurnOnSecondSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TurnOnSecondSwitchWithCallback invokes the arms.TurnOnSecondSwitch API asynchronously
func (client *Client) TurnOnSecondSwitchWithCallback(request *TurnOnSecondSwitchRequest, callback func(response *TurnOnSecondSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TurnOnSecondSwitchResponse
		var err error
		defer close(result)
		response, err = client.TurnOnSecondSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TurnOnSecondSwitchRequest is the request struct for api TurnOnSecondSwitch
type TurnOnSecondSwitchRequest struct {
	*requests.RpcRequest
	Pid              string           `position:"Query" name:"Pid"`
	ReleaseStartTime requests.Integer `position:"Query" name:"ReleaseStartTime"`
	ProxyUserId      string           `position:"Query" name:"ProxyUserId"`
}

// TurnOnSecondSwitchResponse is the response struct for api TurnOnSecondSwitch
type TurnOnSecondSwitchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateTurnOnSecondSwitchRequest creates a request to invoke TurnOnSecondSwitch API
func CreateTurnOnSecondSwitchRequest() (request *TurnOnSecondSwitchRequest) {
	request = &TurnOnSecondSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "TurnOnSecondSwitch", "arms", "openAPI")
	request.Method = requests.GET
	return
}

// CreateTurnOnSecondSwitchResponse creates a response to parse from TurnOnSecondSwitch response
func CreateTurnOnSecondSwitchResponse() (response *TurnOnSecondSwitchResponse) {
	response = &TurnOnSecondSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
