package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrometheusInstances invokes the arms.ListPrometheusInstances API synchronously
func (client *Client) ListPrometheusInstances(request *ListPrometheusInstancesRequest) (response *ListPrometheusInstancesResponse, err error) {
	response = CreateListPrometheusInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrometheusInstancesWithChan invokes the arms.ListPrometheusInstances API asynchronously
func (client *Client) ListPrometheusInstancesWithChan(request *ListPrometheusInstancesRequest) (<-chan *ListPrometheusInstancesResponse, <-chan error) {
	responseChan := make(chan *ListPrometheusInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrometheusInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrometheusInstancesWithCallback invokes the arms.ListPrometheusInstances API asynchronously
func (client *Client) ListPrometheusInstancesWithCallback(request *ListPrometheusInstancesRequest, callback func(response *ListPrometheusInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrometheusInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListPrometheusInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrometheusInstancesRequest is the request struct for api ListPrometheusInstances
type ListPrometheusInstancesRequest struct {
	*requests.RpcRequest
	ShowGlobalView requests.Boolean `position:"Query" name:"ShowGlobalView"`
}

// ListPrometheusInstancesResponse is the response struct for api ListPrometheusInstances
type ListPrometheusInstancesResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateListPrometheusInstancesRequest creates a request to invoke ListPrometheusInstances API
func CreateListPrometheusInstancesRequest() (request *ListPrometheusInstancesRequest) {
	request = &ListPrometheusInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListPrometheusInstances", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPrometheusInstancesResponse creates a response to parse from ListPrometheusInstances response
func CreateListPrometheusInstancesResponse() (response *ListPrometheusInstancesResponse) {
	response = &ListPrometheusInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
