package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMigrationJobs invokes the apds.ListMigrationJobs API synchronously
func (client *Client) ListMigrationJobs(request *ListMigrationJobsRequest) (response *ListMigrationJobsResponse, err error) {
	response = CreateListMigrationJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ListMigrationJobsWithChan invokes the apds.ListMigrationJobs API asynchronously
func (client *Client) ListMigrationJobsWithChan(request *ListMigrationJobsRequest) (<-chan *ListMigrationJobsResponse, <-chan error) {
	responseChan := make(chan *ListMigrationJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMigrationJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMigrationJobsWithCallback invokes the apds.ListMigrationJobs API asynchronously
func (client *Client) ListMigrationJobsWithCallback(request *ListMigrationJobsRequest, callback func(response *ListMigrationJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMigrationJobsResponse
		var err error
		defer close(result)
		response, err = client.ListMigrationJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMigrationJobsRequest is the request struct for api ListMigrationJobs
type ListMigrationJobsRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// ListMigrationJobsResponse is the response struct for api ListMigrationJobs
type ListMigrationJobsResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateListMigrationJobsRequest creates a request to invoke ListMigrationJobs API
func CreateListMigrationJobsRequest() (request *ListMigrationJobsRequest) {
	request = &ListMigrationJobsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "ListMigrationJobs", "/okss-services/migration-job/describe-migration-jobs", "", "")
	request.Method = requests.POST
	return
}

// CreateListMigrationJobsResponse creates a response to parse from ListMigrationJobs response
func CreateListMigrationJobsResponse() (response *ListMigrationJobsResponse) {
	response = &ListMigrationJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
