package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSurveyJobOffline invokes the apds.CreateSurveyJobOffline API synchronously
func (client *Client) CreateSurveyJobOffline(request *CreateSurveyJobOfflineRequest) (response *CreateSurveyJobOfflineResponse, err error) {
	response = CreateCreateSurveyJobOfflineResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSurveyJobOfflineWithChan invokes the apds.CreateSurveyJobOffline API asynchronously
func (client *Client) CreateSurveyJobOfflineWithChan(request *CreateSurveyJobOfflineRequest) (<-chan *CreateSurveyJobOfflineResponse, <-chan error) {
	responseChan := make(chan *CreateSurveyJobOfflineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSurveyJobOffline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSurveyJobOfflineWithCallback invokes the apds.CreateSurveyJobOffline API asynchronously
func (client *Client) CreateSurveyJobOfflineWithCallback(request *CreateSurveyJobOfflineRequest, callback func(response *CreateSurveyJobOfflineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSurveyJobOfflineResponse
		var err error
		defer close(result)
		response, err = client.CreateSurveyJobOffline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSurveyJobOfflineRequest is the request struct for api CreateSurveyJobOffline
type CreateSurveyJobOfflineRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateSurveyJobOfflineResponse is the response struct for api CreateSurveyJobOffline
type CreateSurveyJobOfflineResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateCreateSurveyJobOfflineRequest creates a request to invoke CreateSurveyJobOffline API
func CreateCreateSurveyJobOfflineRequest() (request *CreateSurveyJobOfflineRequest) {
	request = &CreateSurveyJobOfflineRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "CreateSurveyJobOffline", "/okss-services/winback/add-import-survey-job", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSurveyJobOfflineResponse creates a response to parse from CreateSurveyJobOffline response
func CreateCreateSurveyJobOfflineResponse() (response *CreateSurveyJobOfflineResponse) {
	response = &CreateSurveyJobOfflineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
