package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWsCustomizedSeaEcom invokes the alinlp.GetWsCustomizedSeaEcom API synchronously
func (client *Client) GetWsCustomizedSeaEcom(request *GetWsCustomizedSeaEcomRequest) (response *GetWsCustomizedSeaEcomResponse, err error) {
	response = CreateGetWsCustomizedSeaEcomResponse()
	err = client.DoAction(request, response)
	return
}

// GetWsCustomizedSeaEcomWithChan invokes the alinlp.GetWsCustomizedSeaEcom API asynchronously
func (client *Client) GetWsCustomizedSeaEcomWithChan(request *GetWsCustomizedSeaEcomRequest) (<-chan *GetWsCustomizedSeaEcomResponse, <-chan error) {
	responseChan := make(chan *GetWsCustomizedSeaEcomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWsCustomizedSeaEcom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWsCustomizedSeaEcomWithCallback invokes the alinlp.GetWsCustomizedSeaEcom API asynchronously
func (client *Client) GetWsCustomizedSeaEcomWithCallback(request *GetWsCustomizedSeaEcomRequest, callback func(response *GetWsCustomizedSeaEcomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWsCustomizedSeaEcomResponse
		var err error
		defer close(result)
		response, err = client.GetWsCustomizedSeaEcom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWsCustomizedSeaEcomRequest is the request struct for api GetWsCustomizedSeaEcom
type GetWsCustomizedSeaEcomRequest struct {
	*requests.RpcRequest
	Language    string `position:"Body" name:"Language"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Text        string `position:"Body" name:"Text"`
}

// GetWsCustomizedSeaEcomResponse is the response struct for api GetWsCustomizedSeaEcom
type GetWsCustomizedSeaEcomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetWsCustomizedSeaEcomRequest creates a request to invoke GetWsCustomizedSeaEcom API
func CreateGetWsCustomizedSeaEcomRequest() (request *GetWsCustomizedSeaEcomRequest) {
	request = &GetWsCustomizedSeaEcomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetWsCustomizedSeaEcom", "", "")
	request.Method = requests.POST
	return
}

// CreateGetWsCustomizedSeaEcomResponse creates a response to parse from GetWsCustomizedSeaEcom response
func CreateGetWsCustomizedSeaEcomResponse() (response *GetWsCustomizedSeaEcomResponse) {
	response = &GetWsCustomizedSeaEcomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
