package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNerChMedical invokes the alinlp.GetNerChMedical API synchronously
func (client *Client) GetNerChMedical(request *GetNerChMedicalRequest) (response *GetNerChMedicalResponse, err error) {
	response = CreateGetNerChMedicalResponse()
	err = client.DoAction(request, response)
	return
}

// GetNerChMedicalWithChan invokes the alinlp.GetNerChMedical API asynchronously
func (client *Client) GetNerChMedicalWithChan(request *GetNerChMedicalRequest) (<-chan *GetNerChMedicalResponse, <-chan error) {
	responseChan := make(chan *GetNerChMedicalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNerChMedical(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNerChMedicalWithCallback invokes the alinlp.GetNerChMedical API asynchronously
func (client *Client) GetNerChMedicalWithCallback(request *GetNerChMedicalRequest, callback func(response *GetNerChMedicalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNerChMedicalResponse
		var err error
		defer close(result)
		response, err = client.GetNerChMedical(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNerChMedicalRequest is the request struct for api GetNerChMedical
type GetNerChMedicalRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Text        string `position:"Body" name:"Text"`
}

// GetNerChMedicalResponse is the response struct for api GetNerChMedical
type GetNerChMedicalResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetNerChMedicalRequest creates a request to invoke GetNerChMedical API
func CreateGetNerChMedicalRequest() (request *GetNerChMedicalRequest) {
	request = &GetNerChMedicalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetNerChMedical", "", "")
	request.Method = requests.POST
	return
}

// CreateGetNerChMedicalResponse creates a response to parse from GetNerChMedical response
func CreateGetNerChMedicalResponse() (response *GetNerChMedicalResponse) {
	response = &GetNerChMedicalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
