package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCheckDuplicationChMedical invokes the alinlp.GetCheckDuplicationChMedical API synchronously
func (client *Client) GetCheckDuplicationChMedical(request *GetCheckDuplicationChMedicalRequest) (response *GetCheckDuplicationChMedicalResponse, err error) {
	response = CreateGetCheckDuplicationChMedicalResponse()
	err = client.DoAction(request, response)
	return
}

// GetCheckDuplicationChMedicalWithChan invokes the alinlp.GetCheckDuplicationChMedical API asynchronously
func (client *Client) GetCheckDuplicationChMedicalWithChan(request *GetCheckDuplicationChMedicalRequest) (<-chan *GetCheckDuplicationChMedicalResponse, <-chan error) {
	responseChan := make(chan *GetCheckDuplicationChMedicalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCheckDuplicationChMedical(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCheckDuplicationChMedicalWithCallback invokes the alinlp.GetCheckDuplicationChMedical API asynchronously
func (client *Client) GetCheckDuplicationChMedicalWithCallback(request *GetCheckDuplicationChMedicalRequest, callback func(response *GetCheckDuplicationChMedicalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCheckDuplicationChMedicalResponse
		var err error
		defer close(result)
		response, err = client.GetCheckDuplicationChMedical(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCheckDuplicationChMedicalRequest is the request struct for api GetCheckDuplicationChMedical
type GetCheckDuplicationChMedicalRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	OriginT     string `position:"Body" name:"OriginT"`
	OriginQ     string `position:"Body" name:"OriginQ"`
}

// GetCheckDuplicationChMedicalResponse is the response struct for api GetCheckDuplicationChMedical
type GetCheckDuplicationChMedicalResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetCheckDuplicationChMedicalRequest creates a request to invoke GetCheckDuplicationChMedical API
func CreateGetCheckDuplicationChMedicalRequest() (request *GetCheckDuplicationChMedicalRequest) {
	request = &GetCheckDuplicationChMedicalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetCheckDuplicationChMedical", "", "")
	request.Method = requests.POST
	return
}

// CreateGetCheckDuplicationChMedicalResponse creates a response to parse from GetCheckDuplicationChMedical response
func CreateGetCheckDuplicationChMedicalResponse() (response *GetCheckDuplicationChMedicalResponse) {
	response = &GetCheckDuplicationChMedicalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
